package cn.wangshuaitong.library.module.resultconversion;

import cn.wangshuaitong.library.basic.vo.Result;
import cn.wangshuaitong.library.module.resultconversion.annotation.ResultConversion;
import cn.wangshuaitong.library.module.resultconversion.config.ResultConversionProperties;
import cn.wangshuaitong.library.module.resultconversion.converter.ResultConverter;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

/***
 *@author wangt
 *@date 2018/8/16 15:45
 *@describe 结果转换处理器
 **/
@Component
@Aspect
@Slf4j
public class ConverterHandle implements Ordered {

    @Autowired
    private ResultConversionProperties properties;

    @Pointcut("@annotation(cn.wangshuaitong.library.module.resultconversion.annotation.ResultConversion)")
    private void cut() {
    }

    @Around("cut() && @annotation(resultConversion)")
    public Object resultConverter(ProceedingJoinPoint joinPoint, ResultConversion resultConversion) throws Throwable {
        log.debug("结果转换,resultConverter(joinPoint --> joinPoint, resultConversion --> {})", resultConversion);
//        Object result = joinPoint.proceed(new Object[]{1,null});
        Object result = joinPoint.proceed();
        Class aClass = resultConversion.resultConverter();
        ResultConverter resultConverter = (ResultConverter) aClass.newInstance();
        try {
            return resultConverter.conversion((Result) result);
        } catch (Exception e) {
            log.error("结果转换失败！", e);
            return result;
        }
    }

    @Override
    public int getOrder() {
        return properties.getOrder();
    }
}