/*
 * Decompiled with CFR 0.152.
 */
package cn.wangshuaitong.library.module.resultconversion;

import cn.wangshuaitong.library.basic.vo.Result;
import cn.wangshuaitong.library.module.resultconversion.annotation.ResultConversion;
import cn.wangshuaitong.library.module.resultconversion.config.ResultConversionProperties;
import cn.wangshuaitong.library.module.resultconversion.converter.ResultConverter;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ConverterHandle
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(ConverterHandle.class);
    @Autowired
    private ResultConversionProperties properties;

    @Pointcut(value="@annotation(cn.wangshuaitong.library.module.resultconversion.annotation.ResultConversion)")
    private void cut() {
    }

    @Around(value="cut() && @annotation(resultConversion)")
    public Object resultConverter(ProceedingJoinPoint joinPoint, ResultConversion resultConversion) throws Throwable {
        log.debug("\u7ed3\u679c\u8f6c\u6362,resultConverter(joinPoint --> joinPoint, resultConversion --> {})", (Object)resultConversion);
        Object result = joinPoint.proceed();
        Class<? extends ResultConverter> aClass = resultConversion.resultConverter();
        ResultConverter resultConverter = aClass.newInstance();
        try {
            return resultConverter.conversion((Result)result);
        }
        catch (Exception e) {
            log.error("\u7ed3\u679c\u8f6c\u6362\u5931\u8d25\uff01", (Throwable)e);
            return result;
        }
    }

    public int getOrder() {
        return this.properties.getOrder();
    }
}

