package cn.wangshuaitong.library.module.resultconversion.converter;

import cn.wangshuaitong.library.basic.vo.WebResult;
import cn.wangshuaitong.library.basic.vo.response.JsonResult;
import lombok.extern.slf4j.Slf4j;

/***
 *@author wangt
 *@date 2018/8/16 15:53
 *@describe
 **/
@Slf4j
public abstract class WebResultToJsonAbstractResultConverter<F extends WebResult, T extends WebResult> extends WebAbstractResultConverter {
    @Override
    protected WebResult doWebConversion(WebResult fromType) {
        log.debug("处理到JsonResult抽象，doWebConversion(fromType --> {})", fromType);
        if (fromType instanceof JsonResult) {
            log.debug("JsonResult类型，返回原对象");
            return fromType;
        }
        return doToJsonResultConversion((F) fromType);
    }

    protected abstract T doToJsonResultConversion(F fromType);
}
