package cn.wangshuaitong.library.module.resultconversion.converter;

import cn.wangshuaitong.library.basic.vo.Result;

/***
 *@author wangt
 *@date 2018/8/16 15:44
 * @Description: 转换器接口
 * F 要转换的类型
 * T 要转换到的类型
 * 为避免在service层到controller层数据转换的统一编码，使用aop(ConverterHandle)将此块逻辑集中起来
 * 为方便扩展自己的转换器，将转换器定义为接口类（不建议实现此接口，建议扩展AbstractResultConverter），可自定义转换器并在转换注解@ResultConversion中设置转换类型(默认为DefaultResultConverter)
 *
 *
 * 使用aop转换结果时有一个限制，aop代理时由于实际的返回值类型并不会改变，所以转换前类型和转换后类型必须有一个相同的父类声明为代理方法的返回值
 * 在控制层方法层面上，使用Result接口统一标识
 * ？为什么不用Object  为了使方法有其自身的具有语境  比如 Result表明这是一个返回结果 后期根据需求会在Service层也加上此类标识
 **/
public interface ResultConverter<F extends Result,T extends Result> {

    T conversion(F result);

}
