package cn.wangshuaitong.library.module.resultconversion.converter;

import cn.wangshuaitong.library.basic.vo.response.JsonResult;
import cn.wangshuaitong.library.basic.vo.response.code.ResultCode;
import cn.wangshuaitong.library.basic.vo.service.Result4List;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;

/***
 *@author wangt
 *@date 2018/8/16 15:58
 *@describe Result4List类型转JsonResult
 **/
@Slf4j
public class Result4List2JsonResultConverter extends WebResultToJsonAbstractResultConverter<Result4List, JsonResult> {

    @Override
    protected JsonResult doToJsonResultConversion(Result4List fromType) {
        log.debug("Result4List to JsonResult，doConversion(fromType --> {})", fromType);
        JsonResult result = new JsonResult();
        if (fromType.getSuccess()) {
            return result.quickFilling(ResultCode.SUCCESS, fromType.getData());
        }
        log.warn("未查询到数据！");
        // 没有数据时返回空数据认为响应成功
        return result.quickFilling(ResultCode.SUCCESS, new ArrayList<>());
//        return result.quickFilling(ResultCode.FAIL_COMMON_OPERATION,"没有更多数据！");
    }
}
