package cn.wangshuaitong.library.module.resultconversion.converter;

import cn.wangshuaitong.library.basic.vo.Result;
import lombok.extern.slf4j.Slf4j;

/***
 *@author wangt
 *@date 2018/8/16 15:50
 *@describe 转换器抽象  处理了所有转换器都会遇到的情况  如空值处理
 **/
@Slf4j
public abstract class AbstractResultConverter<F extends Result,T extends Result> implements ResultConverter{

    @Override
    public Result conversion(Result result) {
        log.debug("处理结果抽象，conversion(result --> {})",result);
        if(result == null){
            log.info("结果为空，直接返回 null");
            return null;
        }
        return doConversion((F) result);
    }

    protected abstract T doConversion(F fromType);
}