/*
 * Decompiled with CFR 0.152.
 */
package cn.wangshuaitong.library.module.mybatis.generator;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.config.CommentGeneratorConfiguration;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.JDBCConnectionConfiguration;
import org.mybatis.generator.config.JavaClientGeneratorConfiguration;
import org.mybatis.generator.config.JavaModelGeneratorConfiguration;
import org.mybatis.generator.config.JavaTypeResolverConfiguration;
import org.mybatis.generator.config.ModelType;
import org.mybatis.generator.config.PluginConfiguration;
import org.mybatis.generator.config.SqlMapGeneratorConfiguration;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.internal.DefaultShellCallback;

public class MybatisGenerator {
    private Configuration config;
    private Context context;

    public MybatisGenerator() {
        this.init();
    }

    private void init() {
        this.config = new Configuration();
        this.context = new Context(ModelType.CONDITIONAL);
        this.config.addContext(this.context);
        CommentGeneratorConfiguration commentGeneratorConfiguration = new CommentGeneratorConfiguration();
        commentGeneratorConfiguration.addProperty("suppressAllComments", "true");
        this.context.setCommentGeneratorConfiguration(commentGeneratorConfiguration);
        PluginConfiguration pluginConfiguration = new PluginConfiguration();
        pluginConfiguration.setConfigurationType("cn.wangshuaitong.library.module.mybatis.generator.CustomPlugin");
        this.context.addPluginConfiguration(pluginConfiguration);
        JDBCConnectionConfiguration jdbcConnectionConfiguration = new JDBCConnectionConfiguration();
        jdbcConnectionConfiguration.setDriverClass("com.mysql.jdbc.Driver");
        this.context.setJdbcConnectionConfiguration(jdbcConnectionConfiguration);
        JavaTypeResolverConfiguration javaTypeResolverConfiguration = new JavaTypeResolverConfiguration();
        javaTypeResolverConfiguration.addProperty("forceBigDecimals", "false");
        this.context.setJavaTypeResolverConfiguration(javaTypeResolverConfiguration);
        JavaModelGeneratorConfiguration javaModelGeneratorConfiguration = new JavaModelGeneratorConfiguration();
        javaModelGeneratorConfiguration.addProperty("enableSubPackages", "true");
        javaModelGeneratorConfiguration.addProperty("trimStrings", "true");
        this.context.setJavaModelGeneratorConfiguration(javaModelGeneratorConfiguration);
        SqlMapGeneratorConfiguration sqlMapGeneratorConfiguration = new SqlMapGeneratorConfiguration();
        sqlMapGeneratorConfiguration.addProperty("enableSubPackages", "true");
        this.context.setSqlMapGeneratorConfiguration(sqlMapGeneratorConfiguration);
        JavaClientGeneratorConfiguration javaClientGeneratorConfiguration = new JavaClientGeneratorConfiguration();
        javaClientGeneratorConfiguration.setConfigurationType("XMLMAPPER");
        javaClientGeneratorConfiguration.addProperty("enableSubPackages", "true");
        this.context.setJavaClientGeneratorConfiguration(javaClientGeneratorConfiguration);
        this.context.setId("DB2Tables");
        this.context.setTargetRuntime("MyBatis3");
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public Context getContext() {
        return this.context;
    }

    public CommentGeneratorConfiguration getCommentGeneratorConfiguration() {
        return this.context.getCommentGeneratorConfiguration();
    }

    public void addPluginConfiguration(PluginConfiguration pluginConfiguration) {
        this.context.addPluginConfiguration(pluginConfiguration);
    }

    public JDBCConnectionConfiguration getJdbcConnectionConfiguration() {
        return this.context.getJdbcConnectionConfiguration();
    }

    public JavaTypeResolverConfiguration getJavaTypeResolverConfiguration() {
        return this.context.getJavaTypeResolverConfiguration();
    }

    public JavaModelGeneratorConfiguration getJavaModelGeneratorConfiguration() {
        return this.context.getJavaModelGeneratorConfiguration();
    }

    public SqlMapGeneratorConfiguration getSqlMapGeneratorConfiguration() {
        return this.context.getSqlMapGeneratorConfiguration();
    }

    public JavaClientGeneratorConfiguration getJavaClientGeneratorConfiguration() {
        return this.context.getJavaClientGeneratorConfiguration();
    }

    public MybatisGenerator setConnectionURL(String connectionURL) {
        this.context.getJdbcConnectionConfiguration().setConnectionURL(connectionURL);
        return this;
    }

    public MybatisGenerator setUserId(String userId) {
        this.context.getJdbcConnectionConfiguration().setUserId(userId);
        return this;
    }

    public MybatisGenerator setPassword(String password) {
        this.context.getJdbcConnectionConfiguration().setPassword(password);
        return this;
    }

    public MybatisGenerator setJavaModelTargetPackage(String targetPackage) {
        this.context.getJavaModelGeneratorConfiguration().setTargetPackage(targetPackage);
        return this;
    }

    public MybatisGenerator setJavaModelTargetProject(String targetProject) {
        this.context.getJavaModelGeneratorConfiguration().setTargetProject(targetProject);
        return this;
    }

    public MybatisGenerator setSqlMapTargetPackage(String targetPackage) {
        this.context.getSqlMapGeneratorConfiguration().setTargetPackage(targetPackage);
        return this;
    }

    public MybatisGenerator setSqlMapTargetProject(String targetProject) {
        this.context.getSqlMapGeneratorConfiguration().setTargetProject(targetProject);
        return this;
    }

    public MybatisGenerator setJavaClientTargetPackage(String targetPackage) {
        this.context.getJavaClientGeneratorConfiguration().setTargetPackage(targetPackage);
        return this;
    }

    public MybatisGenerator setJavaClientTargetProject(String targetProject) {
        this.context.getJavaClientGeneratorConfiguration().setTargetProject(targetProject);
        return this;
    }

    public MybatisGenerator addTable(String tableName, String domainName) {
        this.addTable(tableName, domainName, config -> {});
        return this;
    }

    public void addTable(String tableName, String domainName, Consumer<TableConfiguration> configurationConsumer) {
        TableConfiguration tableConfiguration = new TableConfiguration(this.context);
        tableConfiguration.setTableName(tableName);
        tableConfiguration.setDomainObjectName(domainName);
        tableConfiguration.setCountByExampleStatementEnabled(false);
        tableConfiguration.setDeleteByExampleStatementEnabled(false);
        tableConfiguration.setSelectByExampleStatementEnabled(false);
        tableConfiguration.setUpdateByExampleStatementEnabled(false);
        tableConfiguration.setSelectByExampleQueryId("false");
        tableConfiguration.setUpdateByPrimaryKeyStatementEnabled(true);
        tableConfiguration.setDeleteByPrimaryKeyStatementEnabled(true);
        tableConfiguration.setSelectByPrimaryKeyStatementEnabled(true);
        configurationConsumer.accept(tableConfiguration);
        this.context.addTableConfiguration(tableConfiguration);
    }

    public void generate() throws Exception {
        ArrayList warnings = new ArrayList();
        boolean overwrite = true;
        DefaultShellCallback callback = new DefaultShellCallback(overwrite);
        MyBatisGenerator myBatisGenerator = new MyBatisGenerator(this.config, (ShellCallback)callback, warnings);
        this.config.validate();
        myBatisGenerator.generate(null);
    }
}

