package cn.wangshuaitong.library.module.mybatis.generator;

import lombok.extern.slf4j.Slf4j;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.*;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/***
 *@author wangt
 *@date 2018/8/16 11:57
 *@describe 自定义插件
 * mybatis生成实体和Mapper时，加额外的注解和注释信息
 **/
@Slf4j
public class CustomPlugin extends PluginAdapter {
    @Override
    public boolean validate(List<String> list) {
        return true;
    }

    @Override
    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        log.debug("lombok import start .....");
        topLevelClass.addImportedType("lombok.Getter");
        topLevelClass.addImportedType("lombok.Setter");
        topLevelClass.addImportedType("lombok.ToString");
        topLevelClass.addImportedType("lombok.experimental.Accessors");
        log.debug("lombok import end .....");
        log.debug("lombok annotation start .....");
        topLevelClass.addAnnotation("@Getter");
        topLevelClass.addAnnotation("@Setter");
        topLevelClass.addAnnotation("@ToString");
        topLevelClass.addAnnotation("@Accessors(chain = true)");
        log.debug("lombok annotation end .....");
        log.debug("docLine start .....");
        topLevelClass.addJavaDocLine("/**");
        topLevelClass.addJavaDocLine("* @Date: " + date2Str(new Date()));
        topLevelClass.addJavaDocLine("* @Description: " + introspectedTable.getFullyQualifiedTable());
        topLevelClass.addJavaDocLine("*/");
        log.debug("docLine end .....");
        return true;
    }

    @Override
    public boolean clientGenerated(Interface interfaze, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        log.debug("import start .....");
        interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Mapper"));
        interfaze.addImportedType(new FullyQualifiedJavaType("org.springframework.stereotype.Repository"));
        log.debug("import end .....");
        log.debug("annotation start .....");
        interfaze.addAnnotation("@Repository");
        interfaze.addAnnotation("@Mapper");
        log.debug("annotation end .....");
        log.debug("docLine start .....");
        interfaze.addJavaDocLine("/**");
        interfaze.addJavaDocLine("* @Date: " + date2Str(new Date()));
        interfaze.addJavaDocLine("* @Description: ");
        interfaze.addJavaDocLine("*/");
        log.debug("docLine end .....");
        return true;
    }

    @Override
    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, ModelClassType modelClassType) {
        field.addJavaDocLine("// " + introspectedColumn.getRemarks() + " [ " + introspectedColumn.getActualColumnName() + " ]");
        return true;
    }

    @Override
    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, ModelClassType modelClassType) {
        return false;
    }

    @Override
    public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, ModelClassType modelClassType) {
        return false;
    }

    private String date2Str(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        return sdf.format(date);
    }
}
