package cn.wangshuaitong.library.module.mybatis.generator;

import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.config.*;
import org.mybatis.generator.internal.DefaultShellCallback;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

/**
 * @author wangt
 * @date 2022/9/8 16:21
 * @describe
 **/
public class MybatisGenerator {

    private Configuration config;

    private Context context;

    public MybatisGenerator() {
        init();
    }

    /**
     * 初始化配置
     */
    private void init() {
        // 创建配置
        config = new Configuration();
        // 配置context
        context = new Context(ModelType.CONDITIONAL);
        config.addContext(context);
        // commentGenerator
        CommentGeneratorConfiguration commentGeneratorConfiguration = new CommentGeneratorConfiguration();
        commentGeneratorConfiguration.addProperty("suppressAllComments", "true");
        context.setCommentGeneratorConfiguration(commentGeneratorConfiguration);
        // plugin
        PluginConfiguration pluginConfiguration = new PluginConfiguration();
        pluginConfiguration.setConfigurationType("com.yzlsoft.lib.mybatis.generator.plugins.CustomPlugin");
        context.addPluginConfiguration(pluginConfiguration);
        // jdbc
        JDBCConnectionConfiguration jdbcConnectionConfiguration = new JDBCConnectionConfiguration();
        jdbcConnectionConfiguration.setDriverClass("com.mysql.jdbc.Driver");
        context.setJdbcConnectionConfiguration(jdbcConnectionConfiguration);
        // javaTypeResolver
        JavaTypeResolverConfiguration javaTypeResolverConfiguration = new JavaTypeResolverConfiguration();
        javaTypeResolverConfiguration.addProperty("forceBigDecimals", "false");
        context.setJavaTypeResolverConfiguration(javaTypeResolverConfiguration);
        // javaModelGenerator
        JavaModelGeneratorConfiguration javaModelGeneratorConfiguration = new JavaModelGeneratorConfiguration();
        javaModelGeneratorConfiguration.addProperty("enableSubPackages", "true");
        javaModelGeneratorConfiguration.addProperty("trimStrings", "true");
        context.setJavaModelGeneratorConfiguration(javaModelGeneratorConfiguration);
        // sqlMap
        SqlMapGeneratorConfiguration sqlMapGeneratorConfiguration = new SqlMapGeneratorConfiguration();
        sqlMapGeneratorConfiguration.addProperty("enableSubPackages", "true");
        context.setSqlMapGeneratorConfiguration(sqlMapGeneratorConfiguration);
        // javaClientGenerator
        JavaClientGeneratorConfiguration javaClientGeneratorConfiguration = new JavaClientGeneratorConfiguration();
        javaClientGeneratorConfiguration.setConfigurationType("XMLMAPPER");
        javaClientGeneratorConfiguration.addProperty("enableSubPackages", "true");
        context.setJavaClientGeneratorConfiguration(javaClientGeneratorConfiguration);
        // table
        context.setId("DB2Tables");
        context.setTargetRuntime("MyBatis3");
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public Context getContext() {
        return this.context;
    }

    public CommentGeneratorConfiguration getCommentGeneratorConfiguration() {
        return context.getCommentGeneratorConfiguration();
    }

    public void addPluginConfiguration(PluginConfiguration pluginConfiguration) {
        context.addPluginConfiguration(pluginConfiguration);
    }

    public JDBCConnectionConfiguration getJdbcConnectionConfiguration() {
        return context.getJdbcConnectionConfiguration();
    }

    public JavaTypeResolverConfiguration getJavaTypeResolverConfiguration() {
        return context.getJavaTypeResolverConfiguration();
    }

    public JavaModelGeneratorConfiguration getJavaModelGeneratorConfiguration() {
        return context.getJavaModelGeneratorConfiguration();
    }

    public SqlMapGeneratorConfiguration getSqlMapGeneratorConfiguration() {
        return context.getSqlMapGeneratorConfiguration();
    }

    public JavaClientGeneratorConfiguration getJavaClientGeneratorConfiguration() {
        return context.getJavaClientGeneratorConfiguration();
    }

    public MybatisGenerator setConnectionURL(String connectionURL) {
        context.getJdbcConnectionConfiguration().setConnectionURL(connectionURL);
        return this;
    }

    public MybatisGenerator setUserId(String userId) {
        context.getJdbcConnectionConfiguration().setUserId(userId);
        return this;
    }

    public MybatisGenerator setPassword(String password) {
        context.getJdbcConnectionConfiguration().setPassword(password);
        return this;
    }

    public MybatisGenerator setJavaModelTargetPackage(String targetPackage) {
        context.getJavaModelGeneratorConfiguration().setTargetPackage(targetPackage);
        return this;
    }

    public MybatisGenerator setJavaModelTargetProject(String targetProject) {
        context.getJavaModelGeneratorConfiguration().setTargetProject(targetProject);
        return this;
    }

    public MybatisGenerator setSqlMapTargetPackage(String targetPackage) {
        context.getSqlMapGeneratorConfiguration().setTargetPackage(targetPackage);
        return this;
    }

    public MybatisGenerator setSqlMapTargetProject(String targetProject) {
        context.getSqlMapGeneratorConfiguration().setTargetProject(targetProject);
        return this;
    }

    public MybatisGenerator setJavaClientTargetPackage(String targetPackage) {
        context.getJavaClientGeneratorConfiguration().setTargetPackage(targetPackage);
        return this;
    }

    public MybatisGenerator setJavaClientTargetProject(String targetProject) {
        context.getJavaClientGeneratorConfiguration().setTargetProject(targetProject);
        return this;
    }

    public MybatisGenerator addTable(String tableName, String domainName) {
        addTable(tableName, domainName, config -> {
        });
        return this;
    }

    public void addTable(String tableName, String domainName, Consumer<TableConfiguration> configurationConsumer) {
        TableConfiguration tableConfiguration = new TableConfiguration(context);
        tableConfiguration.setTableName(tableName);
        tableConfiguration.setDomainObjectName(domainName);
        tableConfiguration.setCountByExampleStatementEnabled(false);
        tableConfiguration.setDeleteByExampleStatementEnabled(false);
        tableConfiguration.setSelectByExampleStatementEnabled(false);
        tableConfiguration.setUpdateByExampleStatementEnabled(false);
        tableConfiguration.setSelectByExampleQueryId("false");
        tableConfiguration.setUpdateByPrimaryKeyStatementEnabled(true);
        tableConfiguration.setDeleteByPrimaryKeyStatementEnabled(true);
        tableConfiguration.setSelectByPrimaryKeyStatementEnabled(true);
        configurationConsumer.accept(tableConfiguration);
        context.addTableConfiguration(tableConfiguration);
    }

    /**
     * 生成
     *
     * @throws Exception
     */
    public void generate() throws Exception {
        List<String> warnings = new ArrayList<>();
        boolean overwrite = true;
        DefaultShellCallback callback = new DefaultShellCallback(overwrite);
        MyBatisGenerator myBatisGenerator = new MyBatisGenerator(config, callback, warnings);
        config.validate();
        myBatisGenerator.generate(null);
    }

}
