/*
 * Decompiled with CFR 0.152.
 */
package cn.wangshuaitong.library.basic.tools.judge;

import cn.wangshuaitong.library.basic.exception.runtime.InvalidParameterException;
import cn.wangshuaitong.library.basic.tools.CommonTools;
import cn.wangshuaitong.library.basic.tools.StringTools;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterVerificationAssert {
    private static final Logger log = LoggerFactory.getLogger(ParameterVerificationAssert.class);
    private static final String defaultMessage = "\u8bf7\u68c0\u67e5\u53c2\u6570";

    public static <T extends Comparable> void range(T number, T min, T max, String logMessage) {
        ParameterVerificationAssert.range(number, min, max, logMessage, defaultMessage);
    }

    public static <T extends Comparable> void range(T number, T min, T max, String logMessage, boolean rollback) {
        ParameterVerificationAssert.range(number, min, max, logMessage, defaultMessage, rollback);
    }

    public static <T extends Comparable> void range(T number, T min, T max, String logMessage, String message) {
        ParameterVerificationAssert.judge(!CommonTools.range(number, min, max), logMessage, message, false);
    }

    public static <T extends Comparable> void range(T number, T min, T max, String logMessage, String message, boolean rollback) {
        ParameterVerificationAssert.judge(!CommonTools.range(number, min, max), logMessage, message, rollback);
    }

    public static void isEmpty(CharSequence value, String logMessage) {
        ParameterVerificationAssert.isEmpty(value, logMessage, defaultMessage);
    }

    public static void isEmpty(CharSequence value, String logMessage, String message) {
        ParameterVerificationAssert.judge(StringTools::isEmpty, value, logMessage, message);
    }

    public static void isEmpty(CharSequence value, String logMessage, boolean rollback) {
        ParameterVerificationAssert.isEmpty(value, logMessage, defaultMessage, rollback);
    }

    public static void isEmpty(CharSequence value, String logMessage, String message, boolean rollback) {
        ParameterVerificationAssert.judge(StringTools::isEmpty, value, logMessage, message, rollback);
    }

    public static void isNull(Object value, String logMessage) {
        ParameterVerificationAssert.isNull(value, logMessage, defaultMessage);
    }

    public static void isNull(Object value, String logMessage, String message) {
        ParameterVerificationAssert.judge(CommonTools::isNull, value, logMessage, message);
    }

    public static void isNull(Object value, String logMessage, boolean rollback) {
        ParameterVerificationAssert.isNull(value, logMessage, defaultMessage, rollback);
    }

    public static void isNull(Object value, String logMessage, String message, boolean rollback) {
        ParameterVerificationAssert.judge(CommonTools::isNull, value, logMessage, message, rollback);
    }

    public static <T> void judge(Predicate<T> predicate, T value, String logMessage, String message, boolean rollback) {
        ParameterVerificationAssert.judge(predicate.test(value), logMessage, message, rollback);
    }

    public static <T> void judge(Predicate<T> predicate, T value, String logMessage, String message) {
        ParameterVerificationAssert.judge(predicate.test(value), logMessage, message, false);
    }

    public static <T> void judge(Predicate<T> predicate, T value, String logMessage) {
        ParameterVerificationAssert.judge(predicate.test(value), logMessage, defaultMessage, false);
    }

    public static <T> void judge(Predicate<T> predicate, T value, String logMessage, boolean rollback) {
        ParameterVerificationAssert.judge(predicate.test(value), logMessage, defaultMessage, rollback);
    }

    public static void judge(boolean result, String logMessage) {
        ParameterVerificationAssert.judge(result, logMessage, defaultMessage, false);
    }

    public static void judge(boolean result, String logMessage, boolean rollback) {
        ParameterVerificationAssert.judge(result, logMessage, defaultMessage, rollback);
    }

    public static void judge(boolean result, String logMessage, String message) {
        if (result) {
            throw new InvalidParameterException(message, logMessage, false);
        }
    }

    public static void judge(boolean result, String logMessage, String message, boolean rollback) {
        if (result) {
            throw new InvalidParameterException(message, logMessage, rollback);
        }
    }
}

