/*
 * Decompiled with CFR 0.152.
 */
package cn.wangshuaitong.library.basic.tools;

import cn.wangshuaitong.library.basic.tools.ArrayTools;
import cn.wangshuaitong.library.basic.tools.StringTools;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyinTools {
    private static final Pattern specialCharacterPattern = Pattern.compile("[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}<>\u300a\u300b\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]");
    private static final Pattern chinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");

    public static String getAlpha(String chines) {
        chines = PinyinTools.cleanChar(chines);
        String pinyinName = "";
        char[] nameChar = chines.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < nameChar.length; ++i) {
            if (nameChar[i] > '\u0080') {
                try {
                    pinyinName = pinyinName + PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0].charAt(0);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pinyinName = pinyinName + nameChar[i];
        }
        return pinyinName;
    }

    public static String getHanziPinYin(String hanzi) {
        String result = null;
        if (StringTools.isNotEmpty(hanzi)) {
            char[] charArray = hanzi.toCharArray();
            StringBuffer sb = new StringBuffer();
            for (char ch : charArray) {
                String[] stringArray = PinyinHelper.toHanyuPinyinStringArray((char)ch);
                if (!ArrayTools.isNotEmpty(stringArray)) continue;
                String pinyin = stringArray[0].replaceAll("\\d", "");
                sb.append(pinyin.substring(0, 1).toUpperCase());
                sb.append(pinyin.substring(1, pinyin.length()));
            }
            if (sb.length() > 0) {
                result = sb.toString();
            }
        }
        return result;
    }

    private static String cleanChar(String chines) {
        chines = chines.replaceAll("[\\p{Punct}\\p{Space}]+", "");
        Matcher matcher = specialCharacterPattern.matcher(chines);
        chines = matcher.replaceAll("").trim();
        return chines;
    }

    public static boolean isContainChinese(String str) {
        Matcher m = chinesePattern.matcher(str);
        return m.find();
    }

    public static void main(String[] args) {
        System.out.println(PinyinTools.getHanziPinYin("\u5218\u884c\u5764"));
    }
}

