/*
 * Decompiled with CFR 0.152.
 */
package cn.wangshuaitong.library.basic.tools;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.function.Function;

public class DateTools {
    public static int intervalDays(Date start, Date end) {
        return (int)((end.getTime() - start.getTime()) / 86400000L);
    }

    public static Date oneYearAfter(Date date) {
        return DateTools.dataAnalysis4LocalDate(date, localDate -> localDate.plusYears(1L).minusDays(1L));
    }

    public static Date beginningOfMonth(Date date) {
        return DateTools.dataAnalysis4LocalDate(date, localDate -> LocalDate.of(localDate.getYear(), localDate.getMonth(), 1));
    }

    public static Date endOfMonth(Date date) {
        return DateTools.dataAnalysis4LocalDate(date, localDate -> {
            localDate = localDate.plusMonths(1L);
            return LocalDate.of(localDate.getYear(), localDate.getMonth(), 1).minusDays(1L);
        });
    }

    public static Date lastMonth(Date date) {
        return DateTools.dataAnalysis4LocalDate(date, localDate -> localDate.minusMonths(1L));
    }

    public static Date nextMonth(Date date) {
        return DateTools.dataAnalysis4LocalDate(date, localDate -> localDate.plusMonths(1L));
    }

    public static Date today(Date date) {
        return DateTools.someDaysAfter(date, 1);
    }

    public static Date someDaysAfter(Date date, int days) {
        return DateTools.dataAnalysis4LocalDate(date, localDate -> localDate.plusDays(days));
    }

    public static Date lastYearEndMonth(Date date) {
        return DateTools.dataAnalysis4LocalDate(date, localDate -> {
            LocalDate lastLocalDate = localDate.minusYears(1L);
            return LocalDate.of(lastLocalDate.getYear(), 12, 1);
        });
    }

    public static Date lastYearFirstMonth(Date date) {
        return DateTools.dataAnalysis4LocalDate(date, localDate -> {
            LocalDate lastLocalDate = localDate.minusYears(1L);
            return LocalDate.of(lastLocalDate.getYear(), 1, 1);
        });
    }

    public static Date yearFirstMonth(Date date) {
        return DateTools.dataAnalysis4LocalDate(date, localDate -> LocalDate.of(localDate.getYear(), 1, 1));
    }

    public static Date dataAnalysis4LocalDate(Date date, Function<LocalDate, LocalDate> function) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate localDate = localDateTime.toLocalDate();
        LocalDate lastLocalDate = function.apply(localDate);
        ZonedDateTime zdt = lastLocalDate.atStartOfDay(zone);
        return Date.from(zdt.toInstant());
    }

    public static Date getNowDate() {
        LocalDate localDate = LocalDate.now();
        ZonedDateTime zdt = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zdt.toInstant());
    }

    public static void main(String[] args) {
        System.out.println(22.883333333333336);
    }
}

