/*
 * Decompiled with CFR 0.152.
 */
package cn.wangshuaitong.library.basic.tools;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.function.Function;
import java.util.function.ToLongBiFunction;

public class DateTimeTools {
    public static Date dataAnalysis4LocalDateTime(Date date, Function<LocalDateTime, LocalDateTime> function) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDateTime resultLocalDateTime = function.apply(localDateTime);
        ZonedDateTime zdt = resultLocalDateTime.atZone(zone);
        return Date.from(zdt.toInstant());
    }

    public static Date dateYearEarlyDate(Date date) {
        return DateTimeTools.dataAnalysis4LocalDateTime(date, localDateTime -> LocalDateTime.of(localDateTime.getYear(), 1, 1, 0, 0, 0));
    }

    public static Date dateYearEndDate(Date date) {
        return DateTimeTools.dataAnalysis4LocalDateTime(date, localDateTime -> LocalDateTime.of(localDateTime.getYear(), 12, 31, 23, 59, 59));
    }

    public static Date dateBeforeYearYearEarlyDate(Date date, int year) {
        return DateTimeTools.dataAnalysis4LocalDateTime(date, localDateTime -> {
            LocalDateTime beforeDateTime = localDateTime.minusYears(year);
            return LocalDateTime.of(beforeDateTime.getYear(), 1, 1, 0, 0, 0);
        });
    }

    public static Date dateAfterYearYearEndDate(Date date, int year) {
        return DateTimeTools.dataAnalysis4LocalDateTime(date, localDateTime -> {
            LocalDateTime afterDateTime = localDateTime.plusYears(year);
            return LocalDateTime.of(afterDateTime.getYear(), 12, 31, 23, 59, 59);
        });
    }

    public static Date dateBeforeMonthMonthEarlyDate(Date date, int month) {
        return DateTimeTools.dataAnalysis4LocalDateTime(date, localDateTime -> {
            LocalDateTime beforeDateTime = localDateTime.minusMonths(month);
            return LocalDateTime.of(beforeDateTime.getYear(), beforeDateTime.getMonth(), 1, 0, 0, 0);
        });
    }

    public static Date dateAfterMonthMonthEarlyDate(Date date, int month) {
        return DateTimeTools.dataAnalysis4LocalDateTime(date, localDateTime -> {
            LocalDateTime beforeDateTime = localDateTime.plusMonths(month);
            return LocalDateTime.of(beforeDateTime.getYear(), beforeDateTime.getMonth(), 1, 0, 0, 0);
        });
    }

    public static Date nextMonth(Date date) {
        return DateTimeTools.plusMonth(date, 1);
    }

    public static Date plusMonth(Date date, int increase) {
        return DateTimeTools.dataAnalysis4LocalDateTime(date, localDateTime -> {
            LocalDateTime beforeDateTime = localDateTime.plusMonths(increase);
            return LocalDateTime.of(beforeDateTime.getYear(), beforeDateTime.getMonth(), beforeDateTime.getDayOfMonth(), beforeDateTime.getHour(), beforeDateTime.getMinute(), beforeDateTime.getSecond());
        });
    }

    public static Date nextYear(Date date) {
        return DateTimeTools.plusYear(date, 1);
    }

    public static Date plusYear(Date date, int increase) {
        return DateTimeTools.dataAnalysis4LocalDateTime(date, localDateTime -> {
            LocalDateTime beforeDateTime = localDateTime.plusYears(increase);
            return LocalDateTime.of(beforeDateTime.getYear(), beforeDateTime.getMonth(), beforeDateTime.getDayOfMonth(), beforeDateTime.getHour(), beforeDateTime.getMinute(), beforeDateTime.getSecond());
        });
    }

    public static Date dateAfterMonthMonthEndDate(Date date, int month) {
        return DateTimeTools.dataAnalysis4LocalDateTime(date, localDateTime -> {
            LocalDateTime afterDateTime = localDateTime.plusMonths(month);
            return LocalDateTime.of(afterDateTime.getYear(), afterDateTime.getMonth(), 31, 23, 59, 59);
        });
    }

    public static Date startTime4SameDay(Date date) {
        return DateTimeTools.dataAnalysis4LocalDateTime(date, localDateTime -> LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonth(), localDateTime.getDayOfMonth(), 0, 0, 0));
    }

    public static Date endTime4SameDay(Date date) {
        return DateTimeTools.dataAnalysis4LocalDateTime(date, localDateTime -> LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonth(), localDateTime.getDayOfMonth(), 23, 59, 59));
    }

    public static Date endMonthTime4SameDay(Date date) {
        Date nextMonthEarlyDate = DateTimeTools.dateAfterMonthMonthEarlyDate(date, 1);
        return DateTimeTools.dataAnalysis4LocalDateTime(nextMonthEarlyDate, localDateTime -> {
            LocalDateTime afterDateTime = localDateTime.minusDays(1L);
            return LocalDateTime.of(afterDateTime.getYear(), afterDateTime.getMonth(), afterDateTime.getDayOfMonth(), 23, 59, 59);
        });
    }

    public static Date afterSecondDate(int second) {
        return DateTimeTools.afterSecondDate(new Date(), second);
    }

    public static Date afterSecondDate(Date date, int second) {
        return DateTimeTools.timeStampConversion(date, second, (date1, second1) -> date1.getTime() + (long)(second1 * 1000));
    }

    public static <T> Date timeStampConversion(Date date, T afterAmount, ToLongBiFunction<Date, T> operator) {
        long time = operator.applyAsLong(date, (Date)afterAmount);
        return new Date(time);
    }

    public static Date nowDate() {
        LocalDateTime localDateTime = LocalDateTime.now();
        ZonedDateTime zdt = localDateTime.atZone(ZoneId.systemDefault());
        return Date.from(zdt.toInstant());
    }

    public static LocalDateTime now() {
        return LocalDateTime.now();
    }

    public static Date startTime4SameDayAgo(Date date, Integer daysAgo) {
        return DateTimeTools.dataAnalysis4LocalDateTime(date, localDateTime -> {
            LocalDateTime daysAgoLocalDateTime = localDateTime.minusDays(daysAgo - 1);
            return LocalDateTime.of(daysAgoLocalDateTime.getYear(), daysAgoLocalDateTime.getMonth(), daysAgoLocalDateTime.getDayOfMonth(), 0, 0, 0);
        });
    }

    public static Date sameDayDaysLater(Date date, Integer daysLater) {
        return DateTimeTools.dataAnalysis4LocalDateTime(date, localDateTime -> localDateTime.plusDays(daysLater.intValue()));
    }

    public static Integer getDateYear(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.getYear();
    }

    public static void main(String[] args) {
    }
}

