/*
 * Decompiled with CFR 0.152.
 */
package cn.wangshuaitong.library.basic.tools;

import cn.wangshuaitong.library.basic.tools.ArrayTools;
import cn.wangshuaitong.library.basic.tools.CollectionTools;
import cn.wangshuaitong.library.basic.tools.StringTools;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class CommonTools {
    public static final String PHONE_NUMBER_PATTERN_STR = "^((12[0-9])|(13[0-9])|(15[0-9])|(17[0-9])|(18[0-9]))\\d{8}$";
    public static final Pattern PHONE_NUMBER_PATTERN = Pattern.compile("^((12[0-9])|(13[0-9])|(15[0-9])|(17[0-9])|(18[0-9]))\\d{8}$");
    public static final String TELEPHONE_NUMBER_PATTERN_STR = "^([0-9]{3,4}-?)[0-9]{7,8}$";
    public static final Pattern TELEPHONE_NUMBER_PATTERN = Pattern.compile("^([0-9]{3,4}-?)[0-9]{7,8}$");
    public static final String ID_CARD_PATTERN_STR = "^(^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$)|(^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])((\\d{4})|\\d{3}[Xx])$)$";
    public static final Pattern ID_CARD_PATTERN = Pattern.compile("^(^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$)|(^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])((\\d{4})|\\d{3}[Xx])$)$");
    public static final String MAIL_PATTERN_STR = "^([a-zA-Z0-9]*[-_]?[a-zA-Z0-9]+)*@([a-zA-Z0-9]*[-_]?[a-zA-Z0-9]+)+[\\\\.][A-Za-z]{2,3}([\\\\.][A-Za-z]{2})?$";
    public static final Pattern MAIL_PATTERN = Pattern.compile("^([a-zA-Z0-9]*[-_]?[a-zA-Z0-9]+)*@([a-zA-Z0-9]*[-_]?[a-zA-Z0-9]+)+[\\\\.][A-Za-z]{2,3}([\\\\.][A-Za-z]{2})?$");
    public static final String URL_PATTERN_STR = "^(http|https)://[\\w\\.\\-]+(?:/|(?:/[\\w\\.\\-]+)*)?$";
    public static final Pattern URL_PATTERN = Pattern.compile("^(http|https)://[\\w\\.\\-]+(?:/|(?:/[\\w\\.\\-]+)*)?$");
    public static final String NUMBER_PATTERN_STR = "^[0-9]*$";
    public static final Pattern NUMBER_PATTERN = Pattern.compile("^[0-9]*$");

    public static <T> boolean isNull(T value) {
        return null == value;
    }

    public static <T> boolean isNotNull(T value) {
        return null != value;
    }

    public static <T> boolean isEquals(T value1, T value2) {
        if (null == value1 && null == value2) {
            return true;
        }
        if (null == value1) {
            return false;
        }
        return value1.equals(value2);
    }

    public static <T> boolean isNotEquals(T value1, T value2) {
        return !CommonTools.isEquals(value1, value2);
    }

    public static <T extends Comparable> boolean range(T number, T min, T max) {
        return number.compareTo(min) >= 0 && number.compareTo(max) <= 0;
    }

    public static boolean isPhoneNumber(String phoneNumber) {
        if (StringTools.isEmpty(phoneNumber)) {
            return false;
        }
        return PHONE_NUMBER_PATTERN.matcher(phoneNumber).matches();
    }

    public static boolean isNotPhoneNumber(String phoneNumber) {
        return !CommonTools.isPhoneNumber(phoneNumber);
    }

    public static boolean isTelephoneNumber(String telephoneNumber) {
        if (StringTools.isEmpty(telephoneNumber)) {
            return false;
        }
        return TELEPHONE_NUMBER_PATTERN.matcher(telephoneNumber).matches();
    }

    public static boolean isIdCard(String idCard) {
        if (StringTools.isEmpty(idCard)) {
            return false;
        }
        return ID_CARD_PATTERN.matcher(idCard).matches();
    }

    public static boolean isMail(String mail) {
        if (StringTools.isEmpty(mail)) {
            return false;
        }
        return MAIL_PATTERN.matcher(mail).matches();
    }

    public static boolean isURL(String url) {
        if (StringTools.isEmpty(url)) {
            return false;
        }
        return URL_PATTERN.matcher(url).matches();
    }

    public static boolean isNotURL(String url) {
        return !CommonTools.isURL(url);
    }

    public static boolean isNumber(String number) {
        if (StringTools.isEmpty(number)) {
            return false;
        }
        return NUMBER_PATTERN.matcher(number).matches();
    }

    public static void noEmptyHandle(String value, Consumer<String> handle) {
        CommonTools.trueThenHandler(StringTools::isNotEmpty, handle, value);
    }

    public static <T> void noNullHandle(T value, Consumer<T> handle) {
        CommonTools.trueThenHandler(CommonTools::isNotNull, handle, value);
    }

    public static <T> void noNullHandle4Array(T[] value, Consumer<T[]> handle) {
        CommonTools.trueThenHandler(ArrayTools::isNotEmpty, handle, value);
    }

    public static <T> void noNullHandle4Collection(List<T> value, Consumer<List<T>> handle) {
        CommonTools.trueThenHandler(CollectionTools::isNotEmpty, handle, value);
    }

    public static <T> void trueThenHandler(Predicate<T> judgeExpression, Consumer<T> handle, T value) {
        CommonTools.trueThenHandler(judgeExpression, value, handle, value);
    }

    public static <T, R> void trueThenHandler(Predicate<T> judgeExpression, T judgeValue, Consumer<R> handle, R handleValue) {
        if (judgeExpression.test(judgeValue)) {
            handle.accept(handleValue);
        }
    }
}

