package cn.wangshuaitong.library.basic.vo.service;

import cn.wangshuaitong.library.basic.vo.WebResult;
import cn.wangshuaitong.library.basic.vo.response.code.ResultCode;
import lombok.Data;

/***
 *@author wangt
 *@date 2018/8/16 15:25
 *@describe 业务层业务处理结果
 * 统一返回，方便控制层转换数据
 **/
@Data
public class Result4Handle<T> implements WebResult {

    private Boolean success;
    private String message;
    private T data;

    public Result4Handle<T> success() {
        this.success = Boolean.TRUE;
        return this;
    }

    public Result4Handle<T> success(String message, T data) {
        this.success = Boolean.TRUE;
        this.message = message;
        this.data = data;
        return this;
    }

    public Result4Handle<T> success(String message) {
        this.success = Boolean.TRUE;
        this.message = message;
        return this;
    }

    public Result4Handle<T> success(T data) {
        this.success = Boolean.TRUE;
        this.message = ResultCode.SUCCESS.getMessage();
        this.data = data;
        return this;
    }

    public Result4Handle<T> fail(String message) {
        this.success = Boolean.FALSE;
        this.message = message;
        return this;
    }

    public Result4Handle<T> fail(String message, T data) {
        this.success = Boolean.FALSE;
        this.message = message;
        this.data = data;
        return this;
    }

}
