package cn.wangshuaitong.library.basic.vo.response;

import lombok.Data;
import cn.wangshuaitong.library.basic.vo.WebResult;
import cn.wangshuaitong.library.basic.vo.response.code.ResultCode;

/***
 *@author wangt
 *@date 2018/8/16 15:15
 *@describe 响应数据结构
 **/
@Data
public class JsonResult<T> implements WebResult {
    /**
     * 返回结果状态码
     */
    private Integer result;
    /**
     * 返回结果提示
     */
    private String message;
    /**
     * 返回结果值
     */
    private T data;

    public JsonResult quickFilling(T datas) {
        this.data = datas;
        return this;
    }

    /**
     * 使用全局公共状态码设置返回对象
     *
     * @param resultCode 全局公共状态码对象
     * @return
     */
    public JsonResult quickFilling(ResultCode resultCode) {
        this.result = resultCode.getCode();
        this.message = resultCode.getMessage();
        return this;
    }


    /**
     * 使用全局公共状态码设置返回对象
     *
     * @param resultCode 全局公共状态码对象
     * @param message    响应提示消息
     * @return
     */
    public JsonResult quickFilling(ResultCode resultCode, String message) {
        this.result = resultCode.getCode();
        this.message = message;
        return this;
    }

    /**
     * 使用全局公共状态码设置返回对象
     *
     * @param resultCode 全局公共状态码对象
     * @param data       响应数据
     * @return
     */
    public JsonResult quickFilling(ResultCode resultCode, T data) {
        this.quickFilling(resultCode);
        this.data = data;
        return this;
    }

    /**
     * 使用全局公共状态码设置返回对象
     *
     * @param resultCode 全局公共状态码对象
     * @param message    响应提示消息
     * @param data       响应数据
     * @return
     */
    public JsonResult quickFilling(ResultCode resultCode, String message, T data) {
        this.quickFilling(resultCode);
        this.message = message;
        this.data = data;
        return this;
    }
}
