package cn.wangshuaitong.library.basic.tools;

import com.vdurmont.emoji.EmojiParser;
import org.apache.commons.lang3.StringUtils;

/***
 *@author wangt
 *@date 2018/8/16 16:00
 *@describe 字符串工具类
 **/
public class StringTools {

    /**
     * 字符串是否为空
     *
     * @param value 传入字符串
     * @return
     */
    public static boolean isEmpty(CharSequence value) {
        return StringUtils.isEmpty(value);
    }

    /**
     * 字符串是否不为空
     *
     * @param value 传入字符串
     * @return
     */
    public static boolean isNotEmpty(CharSequence value) {
        return !isEmpty(value);
    }

    /**
     * 字符长度限制
     *
     * @param value 传入字符串
     * @param min   最小长度
     * @param max   最长长度
     * @return
     */
    public static boolean rangeLength(String value, Integer min, Integer max) {
        if (isEmpty(value)) {
            return false;
        }
        int length = value.length();
        return CommonTools.range(length, min, max);
    }

    /**
     * 最长长度限制
     *
     * @param value 传入字符串
     * @param max   最长长度
     * @return
     */
    public static boolean maxLength(String value, Integer max) {
        return rangeLength(value, 0, max);
    }

    /**
     * 过滤掉表情
     *
     * @param value
     * @return
     */
    public static String filterEmoji(String value) {
        if (StringTools.isEmpty(value)) {
            return value;
        }
        return EmojiParser.removeAllEmojis(value);
    }

    public static void main(String[] args){
        System.out.println(filterEmoji("132"));
    }

}
