package cn.wangshuaitong.library.basic.tools;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/***
 *@author wangt
 *@date 2018/8/21 14:06
 *@describe
 **/
public class DigestTools {

    public static byte[] doMd5(String content,String charset) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] bytes = md.digest(content.getBytes(charset));
        return bytes;
    }

    /**
     * md5
     * @param content
     * @return
     * @throws UnsupportedEncodingException
     * @throws NoSuchAlgorithmException
     */
    public static String md5(String content) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return ByteTools.standardBytes2HexString(doMd5(content,"utf8"));
    }


    public static byte[] doSHA1(String content,String charset) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] bytes = md.digest(content.getBytes(charset));
        return bytes;
    }

    /**
     * sha1
     * @param content
     * @return
     * @throws UnsupportedEncodingException
     * @throws NoSuchAlgorithmException
     */
    public static String sha1(String content) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return ByteTools.standardBytes2HexString(doSHA1(content,"utf8"));
    }

}
