package cn.wangshuaitong.library.basic.tools;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/***
 *@author wangt
 *@date 2020/3/27 10:28
 *@describe
 **/
public class DateFormatTools {

    private static final Map<String, DateFormat> formatCache = new HashMap();

    public static String format(Date date, String format) {
        if (CommonTools.isNull(date)) {
            return "";
        }
        return getFormat(format).format(date);
    }

    private synchronized static DateFormat getFormat(String format) {
        DateFormat dateFormat = formatCache.get(format);
        if (CommonTools.isNull(dateFormat)) {
            dateFormat = new SimpleDateFormat(format);
            formatCache.put(format, dateFormat);
        }
        return dateFormat;
    }

}
