package cn.wangshuaitong.library.basic.tools;

import java.util.List;
import java.util.function.Consumer;

/***
 *@author wangt
 *@date 2018/9/7 17:29
 *@describe
 **/
public class CollectionTools {

    /**
     * List集合是否为空
     *
     * @param list
     * @return
     */
    public static boolean isEmpty(List list) {
        if (CommonTools.isNull(list)) {
            return true;
        }
        return list.size() == 0;
    }

    /**
     * List集合是否不为空
     *
     * @param list
     * @return
     */
    public static boolean isNotEmpty(List list) {
        return !isEmpty(list);
    }

    /**
     * 通用的处理
     *
     * @param list             原始集合
     * @param oneElementHandle 集合元素为一个时处理器
     * @param originalHandle   集合元素大于一个时的处理器
     * @param <T>              集合类型
     */
    public static <T> void commonHandle(List<T> list, Consumer<T> oneElementHandle, Consumer<List<T>> originalHandle) {
        if (isEmpty(list)) {
            return;
        }
        if (list.size() == 1) {
            oneElementHandle.accept(list.get(0));
        } else {
            originalHandle.accept(list);
        }
    }
}
