package cn.wangshuaitong.library.basic.tools;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import java.io.IOException;

/***
 *@author wangt
 *@date 2018/8/21 14:07
 *@describe
 **/
public class ByteTools {

    /**
     * 获取数组前几位
     * @param bs  原始数组
     * @param digit 位数
     * @return
     */
    public static byte[] getStartByte(byte[] bs ,int digit) {
        byte[] resultBs = new byte[digit];
        for (int i = 0; i < digit; i++) {
            resultBs[i] = bs[i];
        }
        return resultBs;
    }

    /**
     * 字节转换成16进制字符
     * @param bs
     * @return
     */
    @Deprecated
    public static String bytes2hex(byte[] bs) {
        StringBuilder hex = new StringBuilder();
        for (int i = 0; i < bs.length; i++) {
            byte b = bs[i];
            boolean negative = false;// 是否为负数
            if (b < 0) {
                negative = true;
            }
            int inte = Math.abs(b);
            if(negative){
                inte = inte | 0x80;
            }
            String temp = Integer.toHexString(inte & 0xFF);
            if(temp.length() == 1){
                hex.append("0");
            }
            hex.append(temp.toUpperCase());
        }
        return hex.toString();
    }

    /**
     * 字符串转成字节
     * @param hex 字符串
     * @return
     */
    public static byte[] hex2bytes(String hex){
        byte[] bytes = new byte[hex.length()/2];
        for(int i = 0; i< hex.length();i = i+2){
            String subStr = hex.substring(i,i+2);
            boolean negative = false;// 是否为负数
            int inte = Integer.parseInt(subStr ,16);
            if(inte > 127){
                negative = true;
            }
            if(inte == 128){
                inte = -128;
            }else if(negative){
                inte = 0 - (inte & 0x7F);
            }
            byte b = (byte)inte;
            bytes[i/2] = b;
        }
        return bytes;
    }


    /**
     * base64 字节转字符
     * @param bytes
     * @return
     */
    public static String byte2base64(byte[] bytes){
        BASE64Encoder base64Encoder = new BASE64Encoder();
        return base64Encoder.encode(bytes);
    }

    /**
     * base64 字符转字节
     * @param base64
     * @return
     * @throws IOException
     */
    public static byte[] base642byte(String base64) throws IOException {
        BASE64Decoder base64Decoder = new BASE64Decoder();
        return base64Decoder.decodeBuffer(base64);
    }

    public static String standardBytes2HexString(byte[] b) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < b.length; i++) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            ret.append(hex);
        }
        return ret.toString();
    }

}
