package cn.wangshuaitong.library.basic.vo.service;

import cn.wangshuaitong.library.basic.vo.WebResult;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/***
 *@author wangt
 *@date 2018/8/16 15:27
 *@describe 业务层业务处理结果
 * 统一返回，方便控制层转换数据
 **/
@Data
public class Result4List<T> implements WebResult {

    private Boolean success;
    private List<T> data;

    public Result4List(List<T> data) {
        this.data = data;
        if (data == null || data.size() <= 0) {
            this.success = Boolean.FALSE;
        } else {
            this.success = Boolean.TRUE;
        }
    }

    public Result4List() {
        this.success = Boolean.FALSE;
    }

    public static Result4List empty() {
        return new Result4List(new ArrayList());
    }

}
