package cn.wangshuaitong.library.basic.vo.response.code;

import lombok.Data;

/***
 *@author wangt
 *@date 2018/8/16 15:17
 *@describe 响应状态码
 * 集中设置返回状态码信息
 **/
@Data
public class ResultCode {

    public static final ResultCode SUCCESS = new ResultCode(0,"请求成功");
    public static final ResultCode INVALID_PARAM = new ResultCode(2,"请求参数错误");

    public static final ResultCode REQUEST_METHOD_NOT_SUPPORTED = new ResultCode(404,"请求不存在");

    public static final ResultCode SERVER_EXCEPTION = new ResultCode(500,"服务器异常");

    public static final ResultCode NO_AUTHORITY = new ResultCode(610,"无权限");

    public static final ResultCode FAIL_COMMON_OPERATION = new ResultCode(700,"操作失败");


    private final Integer code;
    private final String message;

    public ResultCode(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
