package cn.wangshuaitong.library.basic.tools.judge;

import lombok.extern.slf4j.Slf4j;
import cn.wangshuaitong.library.basic.exception.runtime.InvalidParameterException;
import cn.wangshuaitong.library.basic.tools.CommonTools;
import cn.wangshuaitong.library.basic.tools.StringTools;

import java.util.function.Predicate;

/***
 *@author wangt
 *@date 2018/8/17 17:15
 *@describe
 **/
@Slf4j
public class ParameterVerificationAssert {

    private static final String defaultMessage = "请检查参数";

    /**
     * 范围判断
     *
     * @param number     数据
     * @param min        最小值
     * @param max        最大值
     * @param logMessage 打印日志信息
     * @param <T>
     */
    public static <T extends Comparable> void range(T number, T min, T max, String logMessage) {
        range(number, min, max, logMessage, defaultMessage);
    }

    /**
     * 范围判断
     *
     * @param number     数据
     * @param min        最小值
     * @param max        最大值
     * @param logMessage 打印日志信息
     * @param rollback   是否事务会滚
     * @param <T>
     */
    public static <T extends Comparable> void range(T number, T min, T max, String logMessage, boolean rollback) {
        range(number, min, max, logMessage, defaultMessage, rollback);
    }

    /**
     * 范围判断
     *
     * @param number     数据
     * @param min        最小值
     * @param max        最大值
     * @param logMessage 打印日志信息
     * @param message    提示信息
     * @param <T>
     */
    public static <T extends Comparable> void range(T number, T min, T max, String logMessage, String message) {
        judge(!CommonTools.range(number, min, max), logMessage, message, false);
    }

    /**
     * 范围判断
     *
     * @param number     数据
     * @param min        最小值
     * @param max        最大值
     * @param logMessage 打印日志信息
     * @param message    提示信息
     * @param rollback   是否事务回滚
     * @param <T>
     */
    public static <T extends Comparable> void range(T number, T min, T max, String logMessage, String message, boolean rollback) {
        judge(!CommonTools.range(number, min, max), logMessage, message, rollback);
    }

    /**
     * 是否为空，为空时抛出YZLInvalidParameterException异常
     *
     * @param value      数据
     * @param logMessage 打印日志信息
     */
    public static void isEmpty(CharSequence value, String logMessage) {
        isEmpty(value, logMessage, defaultMessage);
    }

    /**
     * 是否为空
     *
     * @param value      数据
     * @param logMessage 打印日志信息
     * @param message    提示信息
     */
    public static void isEmpty(CharSequence value, String logMessage, String message) {
        judge(StringTools::isEmpty, value, logMessage, message);
    }

    /**
     * 是否为空，为空时抛出YZLInvalidParameterException异常
     *
     * @param value      数据
     * @param logMessage 打印日志信息
     * @param rollback   是否事务回滚
     */
    public static void isEmpty(CharSequence value, String logMessage, boolean rollback) {
        isEmpty(value, logMessage, defaultMessage, rollback);
    }

    /**
     * 是否为空
     *
     * @param value      数据
     * @param logMessage 打印日志信息
     * @param message    提示信息
     * @param rollback   是否事务回滚
     */
    public static void isEmpty(CharSequence value, String logMessage, String message, boolean rollback) {
        judge(StringTools::isEmpty, value, logMessage, message, rollback);
    }

    /**
     * 是否为空，为空时抛出YZLInvalidParameterException异常
     *
     * @param value      数据
     * @param logMessage 打印日志信息
     */
    public static void isNull(Object value, String logMessage) {
        isNull(value, logMessage, defaultMessage);
    }

    /**
     * 是否为空
     *
     * @param value      数据
     * @param logMessage 打印日志信息
     * @param message    提示信息
     */
    public static void isNull(Object value, String logMessage, String message) {
        judge(CommonTools::isNull, value, logMessage, message);
    }

    /**
     * 是否为空，为空时抛出YZLInvalidParameterException异常
     *
     * @param value      数据
     * @param logMessage 打印日志信息
     * @param rollback   是否事务回滚
     */
    public static void isNull(Object value, String logMessage, boolean rollback) {
        isNull(value, logMessage, defaultMessage, rollback);
    }

    /**
     * 是否为空
     *
     * @param value      数据
     * @param logMessage 打印日志信息
     * @param message    提示信息
     * @param rollback   是否事务回滚
     */
    public static void isNull(Object value, String logMessage, String message, boolean rollback) {
        judge(CommonTools::isNull, value, logMessage, message, rollback);
    }

    /**
     * 通用的函数式接口方法，为方便调用
     *
     * @param predicate  函数式接口，接收值返回Boolean结果
     * @param value      接收的值
     * @param logMessage 打印日志信息
     * @param message    提示信息
     * @param <T>        函数式接口处理的类型
     * @param rollback   是否事务回滚
     */
    public static <T> void judge(Predicate<T> predicate, T value, String logMessage, String message, boolean rollback) {
        judge(predicate.test(value), logMessage, message, rollback);
    }

    /**
     * 通用的函数式接口方法，为方便调用
     *
     * @param predicate  函数式接口，接收值返回Boolean结果
     * @param value      接收的值
     * @param logMessage 打印日志信息
     * @param message    提示信息
     * @param <T>        函数式接口处理的类型
     */
    public static <T> void judge(Predicate<T> predicate, T value, String logMessage, String message) {
        judge(predicate.test(value), logMessage, message, false);
    }

    /**
     * 通用的函数式接口方法，为方便调用
     *
     * @param predicate  函数式接口，接收值返回Boolean结果
     * @param value      接收的值
     * @param logMessage 打印日志信息
     * @param <T>        函数式接口处理的类型
     */
    public static <T> void judge(Predicate<T> predicate, T value, String logMessage) {
        judge(predicate.test(value), logMessage, defaultMessage, false);
    }

    /**
     * 通用的函数式接口方法，为方便调用
     *
     * @param predicate  函数式接口，接收值返回Boolean结果
     * @param value      接收的值
     * @param logMessage 打印日志信息
     * @param <T>        函数式接口处理的类型
     * @param rollback   是否事务回滚
     */
    public static <T> void judge(Predicate<T> predicate, T value, String logMessage, boolean rollback) {
        judge(predicate.test(value), logMessage, defaultMessage, rollback);
    }

    /**
     * 通用判断，当result为true时抛出YZLInvalidParameterException异常，表示参数异常
     *
     * @param result     判断结果
     * @param logMessage 打印日志信息
     */
    public static void judge(boolean result, String logMessage) {
        judge(result, logMessage, defaultMessage, false);
    }

    /**
     * 通用判断，当result为true时抛出YZLInvalidParameterException异常，表示参数异常
     *
     * @param result     判断结果
     * @param logMessage 打印日志信息
     * @param rollback   是否事务回滚
     */
    public static void judge(boolean result, String logMessage, boolean rollback) {
        judge(result, logMessage, defaultMessage, rollback);
    }

    /**
     * 通用判断，当result为true时抛出YZLInvalidParameterException异常，表示参数异常
     *
     * @param result     判断结果
     * @param logMessage 打印日志信息
     * @param message    提示信息
     */
    public static void judge(boolean result, String logMessage, String message) {
        if (result) {
            throw new InvalidParameterException(message, logMessage, false);
        }
    }

    /**
     * 通用判断，当result为true时抛出YZLInvalidParameterException异常，表示参数异常
     *
     * @param result     判断结果
     * @param logMessage 打印日志信息
     * @param message    提示信息
     * @param rollback   是否事务回滚
     */
    public static void judge(boolean result, String logMessage, String message, boolean rollback) {
        if (result) {
            throw new InvalidParameterException(message, logMessage, rollback);
        }
    }
}
