package cn.wangshuaitong.library.basic.tools;

import java.time.*;
import java.util.Date;
import java.util.function.Function;

/***
 *@author wangt
 *@date 2018/9/11 15:50
 *@describe 时间工具类
 **/
public class DateTools {

    /**
     * 时间间隔天数
     *
     * @param start 起始时间
     * @param end   结束时间
     * @return
     */
    public static int intervalDays(Date start, Date end) {
        return (int) ((end.getTime() - start.getTime()) / 86400000);
    }

    /**
     * 获取一年后的时间
     *
     * @param date
     * @return
     */
    public static Date oneYearAfter(Date date) {
        return dataAnalysis4LocalDate(date, localDate -> localDate.plusYears(1).minusDays(1));
    }

    /**
     * 获取传入日期的月初日期
     *
     * @param date
     * @return
     */
    public static Date beginningOfMonth(Date date) {
        return dataAnalysis4LocalDate(date, localDate -> LocalDate.of(localDate.getYear(), localDate.getMonth(), 1));
    }

    /**
     * 获取传入日期的月末日期
     *
     * @param date
     * @return
     */
    public static Date endOfMonth(Date date) {
        return dataAnalysis4LocalDate(date, localDate -> {
            localDate = localDate.plusMonths(1);
            return LocalDate.of(localDate.getYear(), localDate.getMonth(), 1).minusDays(1);
        });
    }

    /**
     * 获取上个月
     *
     * @param date
     * @return
     */
    public static Date lastMonth(Date date) {
        return dataAnalysis4LocalDate(date, localDate -> localDate.minusMonths(1));
    }

    /**
     * 获取上个月
     *
     * @param date
     * @return
     */
    public static Date nextMonth(Date date) {
        return dataAnalysis4LocalDate(date, localDate -> localDate.plusMonths(1));
    }

    /**
     * 获取指定后的天数
     *
     * @param date
     * @return
     */
    public static Date today(Date date) {
        return someDaysAfter(date, 1);
    }

    /**
     * 获取指定后的天数
     *
     * @param date
     * @param days
     * @return
     */
    public static Date someDaysAfter(Date date, int days) {
        return dataAnalysis4LocalDate(date, localDate -> localDate.plusDays(days));
    }

    /**
     * 获取去年的最后一个月
     *
     * @return
     */
    public static Date lastYearEndMonth(Date date) {
        return dataAnalysis4LocalDate(date, localDate -> {
            LocalDate lastLocalDate = localDate.minusYears(1);
            return LocalDate.of(lastLocalDate.getYear(), 12, 1);
        });
    }

    /**
     * 获取去年的第一个月
     *
     * @return
     */
    public static Date lastYearFirstMonth(Date date) {
        return dataAnalysis4LocalDate(date, localDate -> {
            LocalDate lastLocalDate = localDate.minusYears(1);
            return LocalDate.of(lastLocalDate.getYear(), 1, 1);
        });
    }

    /**
     * 获取当前年的第一个月
     *
     * @param date
     * @return
     */
    public static Date yearFirstMonth(Date date) {
        return dataAnalysis4LocalDate(date, localDate -> LocalDate.of(localDate.getYear(), 1, 1));
    }

    /**
     * 模板代码，只需处理LocalDate的计算就可以不需要来回转换
     *
     * @param date
     * @param function
     * @return
     */
    public static Date dataAnalysis4LocalDate(Date date, Function<LocalDate, LocalDate> function) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate localDate = localDateTime.toLocalDate();
        LocalDate lastLocalDate = function.apply(localDate);
        ZonedDateTime zdt = lastLocalDate.atStartOfDay(zone);
        return Date.from(zdt.toInstant());
    }

    public static Date getNowDate() {
        LocalDate localDate = LocalDate.now();
        ZonedDateTime zdt = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zdt.toInstant());
    }

    public static void main(String[] args) {
//        Date date = dataAnalysis4LocalDateTime(new Date(), localDate -> localDate.plusDays(1));
//        System.out.println(YMDHMS.format(afterSecondDate(60)));
//        System.out.println(Runtime.getRuntime().availableProcessors());
//        Long now = System.currentTimeMillis();
//        LongStream.rangeClosed(1, 1L).sum();
        System.out.println(29.5 / 3 + 9.75 + 3 + 1.3 - 4 / 3);
    }

}
