package cn.wangshuaitong.library.basic.tools;

import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtils;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

/***
 *@author wangt
 *@date 2019/5/29 10:09
 *@describe
 **/
public class BeanTools {

    public static Map bean2map(Object object) {
        Map params;
        if (object instanceof Map) {
            params = (Map<String, Object>) object;
        } else {
            Map temporary = new BeanMap(object);
            params = new HashMap(temporary);
            // 移除多余的key
            params.remove("class");
        }
        return params;
    }

    public static <T> T copy(T t) {
        try {
            return (T) BeanUtils.cloneBean(t);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void map2Bean(Object source, Map map) throws InvocationTargetException, IllegalAccessException {
        BeanUtils.populate(source, map);
    }

    private static void copyProperties(Object source, Object goal) throws InvocationTargetException, IllegalAccessException {
        BeanUtils.copyProperties(source, goal);
    }


}
