package cn.wangshuaitong.library.basic.tools;

import java.util.Arrays;
import java.util.List;

/***
 *@author wangt
 *@date 2018/8/29 17:51
 *@describe
 **/
public class ArrayTools {

    /**
     * 对象是否为空
     *
     * @param value 传入数组
     * @return
     */
    public static <T> boolean isEmpty(T[] value) {
        if (CommonTools.isNull(value)) {
            return true;
        }
        return value.length == 0;
    }

    /**
     * 对象是否不为空
     *
     * @param value 传入数组
     * @return
     */
    public static <T> boolean isNotEmpty(T[] value) {
        return !isEmpty(value);
    }

    public static <T> List<T> toList(T[] value) {
        if (isEmpty(value)) {
            return null;
        }
        return Arrays.asList(value);
    }
}
