package cn.wangshuaitong.library.basic.exception.runtime;

import lombok.Getter;

/***
 *@author wangt
 *@date 2021/1/28 9:54
 *@describe
 **/
@Getter
public class InvalidParameterException extends BusinessRuntimeException {

    private String logMessage;

    private boolean rollback;

    /**
     * @param message    提示信息
     * @param logMessage 日志打印信息
     */
    public InvalidParameterException(String message, String logMessage) {
        this(message, logMessage, false);
    }

    /**
     * @param message    提示信息
     * @param logMessage 日志打印信息
     * @param rollback   是否事务回滚
     */
    public InvalidParameterException(String message, String logMessage, boolean rollback) {
        super(message);
        this.logMessage = logMessage;
        this.rollback = rollback;
    }


}
