/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.maven.plugin.seimi.util;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class WarUtils {
    public static Artifact getArtifact(MavenProject project, Dependency dependency) {
        for (Object o : project.getArtifacts()) {
            Artifact artifact = (Artifact)o;
            if (!artifact.getGroupId().equals(dependency.getGroupId()) || !artifact.getArtifactId().equals(dependency.getArtifactId()) || !artifact.getType().equals(dependency.getType())) continue;
            if (artifact.getClassifier() == null && dependency.getClassifier() == null) {
                return artifact;
            }
            if (dependency.getClassifier() == null || !dependency.getClassifier().equals(artifact.getClassifier())) continue;
            return artifact;
        }
        return null;
    }

    public static boolean isRelated(Artifact artifact, Dependency dependency) {
        if (artifact == null || dependency == null) {
            return false;
        }
        if (!StringUtils.equals((String)artifact.getGroupId(), (String)dependency.getGroupId())) {
            return false;
        }
        if (!StringUtils.equals((String)artifact.getArtifactId(), (String)dependency.getArtifactId())) {
            return false;
        }
        if (artifact.getVersion() != null ? !artifact.getVersion().equals(dependency.getVersion()) : dependency.getVersion() != null) {
            return false;
        }
        if (artifact.getType() != null ? !artifact.getType().equals(dependency.getType()) : dependency.getType() != null) {
            return false;
        }
        if (artifact.getClassifier() != null ? !artifact.getClassifier().equals(dependency.getClassifier()) : dependency.getClassifier() != null) {
            return false;
        }
        if (artifact.getScope() != null ? !artifact.getScope().equals(dependency.getScope()) : dependency.getScope() != null) {
            return false;
        }
        return artifact.isOptional() == dependency.isOptional();
    }

    public static boolean dependencyEquals(Dependency first, Dependency second) {
        if (first == second) {
            return true;
        }
        if (first.isOptional() != second.isOptional()) {
            return false;
        }
        if (!StringUtils.equals((String)first.getArtifactId(), (String)second.getArtifactId())) {
            return false;
        }
        if (first.getClassifier() != null ? !first.getClassifier().equals(second.getClassifier()) : second.getClassifier() != null) {
            return false;
        }
        if (first.getExclusions() != null ? !first.getExclusions().equals(second.getExclusions()) : second.getExclusions() != null) {
            return false;
        }
        if (!StringUtils.equals((String)first.getGroupId(), (String)second.getGroupId())) {
            return false;
        }
        if (first.getScope() != null ? !first.getScope().equals(second.getScope()) : second.getScope() != null) {
            return false;
        }
        if (first.getSystemPath() != null ? !first.getSystemPath().equals(second.getSystemPath()) : second.getSystemPath() != null) {
            return false;
        }
        if (first.getType() != null ? !first.getType().equals(second.getType()) : second.getType() != null) {
            return false;
        }
        return !(first.getVersion() != null ? !first.getVersion().equals(second.getVersion()) : second.getVersion() != null);
    }
}

