/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.maven.plugin.seimi.packaging;

import cn.wanghaomiao.maven.plugin.seimi.Overlay;
import cn.wanghaomiao.maven.plugin.seimi.packaging.AbstractWarPackagingTask;
import cn.wanghaomiao.maven.plugin.seimi.packaging.WarPackagingContext;
import cn.wanghaomiao.maven.plugin.seimi.util.ClassesPackager;
import cn.wanghaomiao.maven.plugin.seimi.util.PathSet;
import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.InterpolationException;

public class ClassesPackagingTask
extends AbstractWarPackagingTask {
    private final Overlay currentProjectOverlay;

    public ClassesPackagingTask(Overlay currentProjectOverlay) {
        this.currentProjectOverlay = currentProjectOverlay;
    }

    public void performPackaging(WarPackagingContext context) throws MojoExecutionException {
        File webappClassesDirectory = new File(context.getWebappDirectory(), "seimi/classes/");
        if (!webappClassesDirectory.exists()) {
            webappClassesDirectory.mkdirs();
        }
        if (context.getClassesDirectory().exists() && !context.getClassesDirectory().equals(webappClassesDirectory)) {
            if (context.archiveClasses()) {
                this.generateJarArchive(context);
            } else {
                PathSet sources = this.getFilesToIncludes(context.getClassesDirectory(), null, null);
                try {
                    this.copyFiles(this.currentProjectOverlay.getId(), context, context.getClassesDirectory(), sources, "seimi/classes/", false);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not copy webapp classes [" + context.getClassesDirectory().getAbsolutePath() + "]", (Exception)e);
                }
            }
        }
    }

    protected void generateJarArchive(WarPackagingContext context) throws MojoExecutionException {
        String archiveName;
        MavenProject project = context.getProject();
        ArtifactFactory factory = context.getArtifactFactory();
        Artifact artifact = factory.createBuildArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), "jar");
        try {
            archiveName = this.getArtifactFinalName(context, artifact);
        }
        catch (InterpolationException e) {
            throw new MojoExecutionException("Could not get the final name of the artifact [" + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + "]", (Exception)((Object)e));
        }
        String targetFilename = "seimi/lib/" + archiveName;
        if (context.getWebappStructure().registerFile(this.currentProjectOverlay.getId(), targetFilename)) {
            File libDirectory = new File(context.getWebappDirectory(), "seimi/lib/");
            File jarFile = new File(libDirectory, archiveName);
            ClassesPackager packager = new ClassesPackager();
            packager.packageClasses(context.getClassesDirectory(), jarFile, context.getJarArchiver(), context.getSession(), project, context.getArchive());
        } else {
            context.getLog().warn((CharSequence)("Could not generate archive classes file [" + targetFilename + "] has already been copied."));
        }
    }
}

