/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.utils;

import cn.wanghaomiao.seimi.core.SeimiDownloader;
import cn.wanghaomiao.seimi.exception.SeimiProcessExcepiton;
import cn.wanghaomiao.seimi.struct.CrawlerModel;
import java.util.concurrent.ConcurrentHashMap;

public class ClazzUtils {
    private static final ConcurrentHashMap<Class<?>, SeimiDownloader> instanceCache = new ConcurrentHashMap();
    private static final ThreadLocal<CrawlerModel> localCache = new ThreadLocal();

    public static SeimiDownloader getInstance(Class<? extends SeimiDownloader> clazz) {
        SeimiDownloader downloader = instanceCache.get(clazz);
        if (downloader == null) {
            try {
                downloader = clazz.newInstance();
                instanceCache.put(clazz, downloader);
            }
            catch (Exception e) {
                throw new SeimiProcessExcepiton(e);
            }
        }
        return downloader;
    }

    public static CrawlerModel currentCModel() {
        return localCache.get();
    }

    public static void setCurrentCModel(CrawlerModel model) {
        localCache.set(model);
    }
}

