/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.http.hc;

import cn.wanghaomiao.seimi.http.hc.HttpClientConnectionManagerProvider;
import cn.wanghaomiao.seimi.http.hc.SeimiRedirectStrategy;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class HttpClientFactory {
    private static final Map<String, HttpClient> hcCache = new ConcurrentHashMap<String, HttpClient>();

    public static HttpClient getHttpClient() {
        int defTimeout = 10000;
        return HttpClientFactory.getHttpClient(defTimeout);
    }

    public static HttpClient getHttpClient(int timeout) {
        String defKey = String.valueOf(timeout);
        HttpClient hc = hcCache.get(defKey);
        if (hc == null) {
            hc = HttpClientFactory.cliBuilder(timeout).build();
            hcCache.put(defKey, hc);
        }
        return hc;
    }

    public static HttpClient getHttpClient(int timeout, CookieStore cookieStore) {
        return HttpClientFactory.cliBuilder(timeout).setDefaultCookieStore(cookieStore).build();
    }

    public static HttpClientBuilder cliBuilder(int timeout) {
        HttpRequestRetryHandler retryHander = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                boolean idempotent;
                if (executionCount > 3) {
                    return false;
                }
                if (exception instanceof SocketTimeoutException) {
                    return true;
                }
                if (exception instanceof InterruptedIOException) {
                    return true;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
                return idempotent;
            }
        };
        SeimiRedirectStrategy redirectStrategy = new SeimiRedirectStrategy();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = HttpClientConnectionManagerProvider.getHcPoolInstance();
        return HttpClients.custom().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).setRedirectStrategy((RedirectStrategy)redirectStrategy).setRetryHandler(retryHander);
    }
}

