/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.http.hc;

import cn.wanghaomiao.seimi.config.SeimiConfig;
import cn.wanghaomiao.seimi.def.BaseSeimiCrawler;
import cn.wanghaomiao.seimi.exception.SeimiProcessExcepiton;
import cn.wanghaomiao.seimi.http.HttpMethod;
import cn.wanghaomiao.seimi.http.SeimiAgentContentType;
import cn.wanghaomiao.seimi.spring.common.CrawlerCache;
import cn.wanghaomiao.seimi.struct.CrawlerModel;
import cn.wanghaomiao.seimi.struct.Request;
import com.alibaba.fastjson.JSON;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.util.CollectionUtils;

public class HcRequestGenerator {
    public static RequestBuilder getHttpRequestBuilder(Request request, CrawlerModel crawlerModel) {
        RequestBuilder requestBuilder;
        block13: {
            SeimiConfig config;
            BaseSeimiCrawler crawler;
            block16: {
                block14: {
                    block15: {
                        block12: {
                            crawler = crawlerModel.getInstance();
                            if (!request.isUseSeimiAgent()) break block12;
                            config = CrawlerCache.getConfig();
                            if (config == null || StringUtils.isBlank((CharSequence)config.getSeimiAgentHost())) {
                                throw new SeimiProcessExcepiton("SeimiAgentHost is blank.");
                            }
                            String seimiAgentUrl = "http://" + config.getSeimiAgentHost() + (config.getSeimiAgentPort() != 80 ? ":" + config.getSeimiAgentPort() : "") + "/doload";
                            requestBuilder = RequestBuilder.post().setUri(seimiAgentUrl);
                            LinkedList<BasicNameValuePair> linkedList = new LinkedList<BasicNameValuePair>();
                            linkedList.add(new BasicNameValuePair("url", request.getUrl()));
                            if (StringUtils.isNotBlank((CharSequence)crawler.proxy())) {
                                linkedList.add(new BasicNameValuePair("proxy", crawler.proxy()));
                            }
                            if (request.getSeimiAgentRenderTime() > 0L) {
                                linkedList.add(new BasicNameValuePair("renderTime", String.valueOf(request.getSeimiAgentRenderTime())));
                            }
                            if (StringUtils.isNotBlank((CharSequence)request.getSeimiAgentScript())) {
                                linkedList.add(new BasicNameValuePair("script", request.getSeimiAgentScript()));
                            }
                            if (request.isSeimiAgentUseCookie() == null && crawlerModel.isUseCookie() || request.isSeimiAgentUseCookie() != null && request.isSeimiAgentUseCookie().booleanValue()) {
                                linkedList.add(new BasicNameValuePair("useCookie", "1"));
                            }
                            if (request.getParams() != null && request.getParams().size() > 0) {
                                linkedList.add(new BasicNameValuePair("postParam", JSON.toJSONString(request.getParams())));
                            }
                            if (request.getSeimiAgentContentType().val() > SeimiAgentContentType.HTML.val()) {
                                linkedList.add(new BasicNameValuePair("contentType", request.getSeimiAgentContentType().typeVal()));
                            }
                            requestBuilder.setEntity((HttpEntity)new UrlEncodedFormEntity(linkedList, Charset.forName("utf8")));
                            break block13;
                        }
                        if (!HttpMethod.POST.equals((Object)request.getHttpMethod())) break block14;
                        requestBuilder = RequestBuilder.post().setUri(request.getUrl());
                        if (!StringUtils.isNotBlank((CharSequence)request.getJsonBody())) break block15;
                        requestBuilder.addHeader("Content-type", "application/json; charset=utf-8");
                        requestBuilder.setEntity((HttpEntity)new StringEntity(request.getJsonBody(), Charset.forName("UTF-8")));
                        break block16;
                    }
                    if (request.getParams() == null) break block16;
                    LinkedList nameValuePairList = new LinkedList();
                    for (Map.Entry entry : request.getParams().entrySet()) {
                        nameValuePairList.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
                    }
                    requestBuilder.setEntity((HttpEntity)new UrlEncodedFormEntity((Iterable)nameValuePairList, Charset.forName("utf8")));
                    break block16;
                }
                requestBuilder = RequestBuilder.get().setUri(request.getUrl());
                if (request.getParams() != null) {
                    for (Map.Entry<String, String> entry : request.getParams().entrySet()) {
                        requestBuilder.addParameter((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
            config = RequestConfig.custom().setProxy(crawlerModel.getProxy()).setCircularRedirectsAllowed(true).build();
            requestBuilder.setConfig((RequestConfig)config).setHeader("User-Agent", crawlerModel.isUseCookie() ? crawlerModel.getCurrentUA() : crawler.getUserAgent());
            requestBuilder.setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
            requestBuilder.setHeader("Accept-Language", "zh-CN,zh;q=0.8,en;q=0.6");
        }
        if (!CollectionUtils.isEmpty(request.getHeader())) {
            for (Map.Entry<String, String> entry : request.getHeader().entrySet()) {
                requestBuilder.setHeader(entry.getKey(), entry.getValue());
            }
        }
        return requestBuilder;
    }
}

