/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.core;

import cn.wanghaomiao.seimi.annotation.Crawler;
import cn.wanghaomiao.seimi.annotation.Interceptor;
import cn.wanghaomiao.seimi.annotation.Queue;
import cn.wanghaomiao.seimi.core.ScanConfig;
import cn.wanghaomiao.seimi.core.SeimiInterceptor;
import cn.wanghaomiao.seimi.core.SeimiProcessor;
import cn.wanghaomiao.seimi.core.SeimiQueue;
import cn.wanghaomiao.seimi.core.SeimiScanner;
import cn.wanghaomiao.seimi.def.BaseSeimiCrawler;
import cn.wanghaomiao.seimi.exception.SeimiInitExcepiton;
import cn.wanghaomiao.seimi.struct.CrawlerModel;
import cn.wanghaomiao.seimi.utils.StrFormatUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.util.CollectionUtils;

public class SeimiContext
extends AnnotationConfigApplicationContext {
    private int BASE_THREAD_NUM = 2;
    protected ApplicationContext applicationContext;
    protected SeimiScanner seimiScanner;
    protected Set<Class<? extends BaseSeimiCrawler>> crawlers;
    protected Set<Class<? extends SeimiQueue>> hasUsedQuene;
    protected List<SeimiInterceptor> interceptors;
    protected Map<String, CrawlerModel> crawlerModelContext;
    protected ExecutorService workersPool;
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public SeimiContext() {
        this.register(new Class[]{ScanConfig.class});
        this.init();
        if (!CollectionUtils.isEmpty(this.crawlers)) {
            this.prepareCrawlerModels();
            this.workersPool = Executors.newFixedThreadPool(this.BASE_THREAD_NUM * Runtime.getRuntime().availableProcessors() * this.crawlers.size());
            this.prepareWorkerThread();
        } else {
            this.logger.error("can not find any crawlers,please check!");
        }
    }

    protected void waitToEnd() {
        this.workersPool.shutdown();
        try {
            this.workersPool.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void init() {
        String[] targetPkgs = new String[]{"crawlers", "queues", "interceptors", "cn.wanghaomiao.seimi"};
        this.seimiScanner = new SeimiScanner(this);
        Set<Class<?>> aladdin = this.seimiScanner.scan(targetPkgs, Crawler.class, Queue.class, Interceptor.class);
        this.applicationContext = this;
        this.crawlers = new HashSet<Class<? extends BaseSeimiCrawler>>();
        this.hasUsedQuene = new HashSet<Class<? extends SeimiQueue>>();
        this.interceptors = new LinkedList<SeimiInterceptor>();
        this.crawlerModelContext = new HashMap<String, CrawlerModel>();
        LinkedList registList = new LinkedList();
        for (Class<?> cls : aladdin) {
            if (BaseSeimiCrawler.class.isAssignableFrom(cls)) {
                Crawler c = cls.getAnnotation(Crawler.class);
                this.hasUsedQuene.add(c.queue());
                this.crawlers.add(cls);
                registList.add(cls);
                continue;
            }
            if (!SeimiInterceptor.class.isAssignableFrom(cls)) continue;
            registList.add(cls);
        }
        for (Class<?> cls : aladdin) {
            if (!SeimiQueue.class.isAssignableFrom(cls) || !this.hasUsedQuene.contains(cls)) continue;
            registList.add(cls);
        }
        this.seimiScanner.regist(registList);
        for (Class<?> cls : aladdin) {
            if (!SeimiInterceptor.class.isAssignableFrom(cls)) continue;
            this.interceptors.add((SeimiInterceptor)this.applicationContext.getBean(cls));
        }
        Collections.sort(this.interceptors, new Comparator<SeimiInterceptor>(){

            @Override
            public int compare(SeimiInterceptor o1, SeimiInterceptor o2) {
                return o1.getWeight() > o2.getWeight() ? -1 : 1;
            }
        });
    }

    private void prepareCrawlerModels() {
        for (Class<? extends BaseSeimiCrawler> a : this.crawlers) {
            CrawlerModel crawlerModel = new CrawlerModel(a, this.applicationContext);
            if (this.crawlerModelContext.containsKey(crawlerModel.getCrawlerName())) {
                this.logger.error("Crawler:{} is repeated,please check", (Object)crawlerModel.getCrawlerName());
                throw new SeimiInitExcepiton(StrFormatUtil.info("Crawler:{} is repeated,please check", crawlerModel.getCrawlerName()));
            }
            this.crawlerModelContext.put(crawlerModel.getCrawlerName(), crawlerModel);
        }
    }

    private void prepareWorkerThread() {
        for (Map.Entry<String, CrawlerModel> crawlerEntry : this.crawlerModelContext.entrySet()) {
            for (int i = 0; i < this.BASE_THREAD_NUM * Runtime.getRuntime().availableProcessors(); ++i) {
                this.workersPool.execute(new SeimiProcessor(this.interceptors, crawlerEntry.getValue()));
            }
        }
    }
}

