/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.httpd;

import cn.wanghaomiao.seimi.httpd.HttpRequestProcessor;
import cn.wanghaomiao.seimi.struct.CrawlerModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class SeimiHttpHandler
extends AbstractHandler {
    private Map<String, CrawlerModel> crawlerContext;
    private Map<String, HttpRequestProcessor> requestMapper;

    public SeimiHttpHandler(Map<String, CrawlerModel> crawlerContext) {
        this.crawlerContext = crawlerContext;
        this.requestMapper = new HashMap<String, HttpRequestProcessor>();
    }

    public SeimiHttpHandler add(String path, HttpRequestProcessor processor) {
        this.requestMapper.put(path, processor);
        return this;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setHeader("server", "SeimiCrawler");
        HttpRequestProcessor processor = this.requestMapper.get(target);
        if (processor != null) {
            response.setStatus(200);
            processor.handleHttpRequest(request, response);
        } else {
            response.setStatus(404);
        }
        baseRequest.setHandled(true);
    }
}

