/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.def;

import cn.wanghaomiao.seimi.annotation.Queue;
import cn.wanghaomiao.seimi.core.SeimiQueue;
import cn.wanghaomiao.seimi.struct.Request;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Queue
public class DefaultLocalQueue
implements SeimiQueue {
    private Map<String, LinkedBlockingQueue<Request>> queueMap = new HashMap<String, LinkedBlockingQueue<Request>>();
    private Map<String, ConcurrentSkipListSet<String>> processedData = new HashMap<String, ConcurrentSkipListSet<String>>();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Request bPop(String crawlerName) {
        try {
            LinkedBlockingQueue<Request> queue = this.getQueue(crawlerName);
            return queue.take();
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean push(Request req) {
        try {
            LinkedBlockingQueue<Request> queue = this.getQueue(req.getCrawlerName());
            queue.put(req);
            return true;
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public long len(String crawlerName) {
        LinkedBlockingQueue<Request> queue = this.getQueue(crawlerName);
        return queue.size();
    }

    @Override
    public boolean isProcessed(Request req) {
        ConcurrentSkipListSet<String> set = this.getProcessedSet(req.getCrawlerName());
        String sign = DigestUtils.md5Hex((String)req.getUrl());
        return set.contains(sign);
    }

    @Override
    public void addProcessed(Request req) {
        ConcurrentSkipListSet<String> set = this.getProcessedSet(req.getCrawlerName());
        String sign = DigestUtils.md5Hex((String)req.getUrl());
        set.add(sign);
    }

    @Override
    public long totalCrawled(String crawlerName) {
        ConcurrentSkipListSet<String> set = this.getProcessedSet(crawlerName);
        return set.size();
    }

    public LinkedBlockingQueue<Request> getQueue(String crawlerName) {
        LinkedBlockingQueue<Request> queue = this.queueMap.get(crawlerName);
        if (queue == null) {
            queue = new LinkedBlockingQueue();
            this.queueMap.put(crawlerName, queue);
        }
        return queue;
    }

    public ConcurrentSkipListSet<String> getProcessedSet(String crawlerName) {
        ConcurrentSkipListSet<String> set = this.processedData.get(crawlerName);
        if (set == null) {
            set = new ConcurrentSkipListSet();
            this.processedData.put(crawlerName, set);
        }
        return set;
    }
}

