/*
 * Decompiled with CFR 0.152.
 */
package org.seimicrawler.xpath.core.node;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.seimicrawler.xpath.core.NodeTest;
import org.seimicrawler.xpath.core.Scope;
import org.seimicrawler.xpath.core.XValue;
import org.seimicrawler.xpath.util.CommonUtil;

public class Text
implements NodeTest {
    @Override
    public String name() {
        return "text";
    }

    @Override
    public XValue call(Scope scope) {
        Elements res;
        block6: {
            Elements context = scope.context();
            res = new Elements();
            if (context == null || context.size() <= 0) break block6;
            if (scope.isRecursion()) {
                for (Element e : context) {
                    final HashMap indexMap = new HashMap();
                    NodeTraversor.traverse((NodeVisitor)new NodeVisitor(){

                        public void head(Node node, int depth) {
                            if (node instanceof TextNode) {
                                TextNode textNode = (TextNode)node;
                                String key = depth + "_" + textNode.parent().hashCode();
                                Integer index = (Integer)indexMap.get(key);
                                if (index == null) {
                                    index = 1;
                                    indexMap.put(key, index);
                                } else {
                                    index = index + 1;
                                    indexMap.put(key, index);
                                }
                                Element data = new Element("JX_TEXT");
                                data.text(textNode.getWholeText());
                                try {
                                    Method parent = Node.class.getDeclaredMethod("setParentNode", Node.class);
                                    parent.setAccessible(true);
                                    parent.invoke((Object)data, textNode.parent());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                CommonUtil.setSameTagIndexInSiblings(data, index);
                                res.add((Object)data);
                            }
                        }

                        public void tail(Node node, int depth) {
                        }
                    }, (Node)e);
                }
            } else {
                for (Element e : context) {
                    if ("script".equals(e.nodeName())) {
                        Element data = new Element("JX_TEXT");
                        data.text(e.data());
                        CommonUtil.setSameTagIndexInSiblings(data, 1);
                        res.add((Object)data);
                        continue;
                    }
                    List textNodes = e.textNodes();
                    for (int i = 0; i < textNodes.size(); ++i) {
                        TextNode textNode = (TextNode)textNodes.get(i);
                        Element data = new Element("JX_TEXT");
                        data.text(textNode.getWholeText());
                        CommonUtil.setSameTagIndexInSiblings(data, i + 1);
                        res.add((Object)data);
                    }
                }
            }
        }
        return XValue.create(res);
    }
}

