/*
 * Decompiled with CFR 0.152.
 */
package org.seimicrawler.xpath.util;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ImplementingClassMatchProcessor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.seimicrawler.xpath.core.AxisSelector;
import org.seimicrawler.xpath.core.Function;
import org.seimicrawler.xpath.core.NodeTest;
import org.seimicrawler.xpath.exception.NoSuchAxisException;
import org.seimicrawler.xpath.exception.NoSuchFunctionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scanner {
    private static Map<String, AxisSelector> axisSelectorMap = new HashMap<String, AxisSelector>();
    private static Map<String, NodeTest> nodeTestMap = new HashMap<String, NodeTest>();
    private static Map<String, Function> functionMap = new HashMap<String, Function>();
    private static Logger logger = LoggerFactory.getLogger(Scanner.class);

    public static AxisSelector findSelectorByName(String selectorName) {
        AxisSelector selector = axisSelectorMap.get(selectorName);
        if (selector == null) {
            throw new NoSuchAxisException("not support axis: " + selectorName);
        }
        return selector;
    }

    public static NodeTest findNodeTestByName(String nodeTestName) {
        NodeTest nodeTest = nodeTestMap.get(nodeTestName);
        if (nodeTest == null) {
            throw new NoSuchFunctionException("not support nodeTest: " + nodeTestName);
        }
        return nodeTest;
    }

    public static Function findFunctionByName(String funcName) {
        Function function = functionMap.get(funcName);
        if (function == null) {
            throw new NoSuchFunctionException("not support function: " + funcName);
        }
        return function;
    }

    static {
        new FastClasspathScanner(new String[]{Function.class.getPackage().getName()}).matchClassesImplementing(Function.class, (ImplementingClassMatchProcessor)new ImplementingClassMatchProcessor<Function>(){

            public void processMatch(Class<? extends Function> funcClass) {
                try {
                    Function function = funcClass.newInstance();
                    functionMap.put(function.name(), function);
                }
                catch (Exception e) {
                    logger.info(ExceptionUtils.getRootCauseMessage((Throwable)e), (Throwable)e);
                }
            }
        }).matchClassesImplementing(NodeTest.class, (ImplementingClassMatchProcessor)new ImplementingClassMatchProcessor<NodeTest>(){

            public void processMatch(Class<? extends NodeTest> nodeTestClass) {
                try {
                    NodeTest nodeTest = nodeTestClass.newInstance();
                    nodeTestMap.put(nodeTest.name(), nodeTest);
                }
                catch (Exception e) {
                    logger.info(ExceptionUtils.getRootCauseMessage((Throwable)e), (Throwable)e);
                }
            }
        }).matchClassesImplementing(AxisSelector.class, (ImplementingClassMatchProcessor)new ImplementingClassMatchProcessor<AxisSelector>(){

            public void processMatch(Class<? extends AxisSelector> axisSelectorClass) {
                try {
                    AxisSelector axisSelector = axisSelectorClass.newInstance();
                    axisSelectorMap.put(axisSelector.name(), axisSelector);
                }
                catch (Exception e) {
                    logger.info(ExceptionUtils.getRootCauseMessage((Throwable)e), (Throwable)e);
                }
            }
        }).scan();
    }
}

