/*
 * Decompiled with CFR 0.152.
 */
package cn.wangcaitao.starter.fastjson;

import cn.wangcaitao.starter.fastjson.FastJsonProperties;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={FastJsonProperties.class})
@ConditionalOnClass(value={JSON.class})
public class FastJsonAutoConfiguration
implements WebMvcConfigurer {
    @Resource
    private FastJsonProperties fastJsonProperties;

    @Bean
    @ConditionalOnMissingBean
    public FastJsonHttpMessageConverter fastJsonHttpMessageConverter() {
        FastJsonHttpMessageConverter fastJsonHttpMessageConverter = new FastJsonHttpMessageConverter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        SerializerFeature[] serializerFeatures = this.fastJsonProperties.getSerializerFeatures();
        if (null != serializerFeatures && 0 < serializerFeatures.length) {
            fastJsonConfig.setSerializerFeatures(serializerFeatures);
        } else {
            fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteDateUseDateFormat});
        }
        fastJsonHttpMessageConverter.setFastJsonConfig(fastJsonConfig);
        return fastJsonHttpMessageConverter;
    }

    @Bean
    public StringHttpMessageConverter stringHttpMessageConverter() {
        return new StringHttpMessageConverter(Charset.forName("UTF-8"));
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)this.stringHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)this.fastJsonHttpMessageConverter());
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.clear();
        converters.add((HttpMessageConverter<?>)this.stringHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)this.fastJsonHttpMessageConverter());
    }
}

