/*
 * Decompiled with CFR 0.152.
 */
package cn.w2n0.genghiskhan.dubbo.router;

import cn.w2n0.genghiskhan.dubbo.filter.SpringContextUtil;
import cn.w2n0.genghiskhan.dubbo.router.RouterProperties;
import cn.w2n0.genghiskhan.dubbo.router.RouterType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.AbstractRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrayRouter
extends AbstractRouter {
    private static final Logger log = LoggerFactory.getLogger(GrayRouter.class);
    private static final int GRAY_ROUTER_DEFAULT_PRIORITY = 100;
    private static final String GENERICSERVICE = "org.apache.dubbo.rpc.service.GenericService";

    public GrayRouter(URL url) {
        super(url);
        this.priority = 100;
    }

    public <T> List<Invoker<T>> route(List<Invoker<T>> invokers, URL url, Invocation invocation) throws RpcException {
        RouterProperties routerProperties = SpringContextUtil.getBean(RouterProperties.class);
        if (routerProperties != null && routerProperties.isEnable()) {
            boolean isGray = false;
            String value = "";
            if (GENERICSERVICE.equals(invocation.getServiceName()) && invocation.getArguments() != null && invocation.getArguments().length == 3 && invocation.getArguments()[2] instanceof Object[]) {
                Object[] objects = (Object[])invocation.getArguments()[2];
                HashMap paramMap = (HashMap)objects[0];
                if (paramMap.containsKey(routerProperties.getParam())) {
                    value = (String)paramMap.get(routerProperties.getParam());
                }
            } else if (invocation.getObjectAttachments().size() > 0) {
                value = invocation.getAttachment(routerProperties.getParam());
            }
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                if (RouterType.condition.toString().equals(routerProperties.getRule())) {
                    if (routerProperties.getValues().indexOf(value) > -1) {
                        isGray = true;
                        invokers = this.route(routerProperties.getRouters(), invokers);
                    }
                } else if (RouterType.hash.toString().equals(routerProperties.getRule()) && value.hashCode() % 100 <= Integer.valueOf(routerProperties.getValues())) {
                    isGray = true;
                    invokers = this.route(routerProperties.getRouters(), invokers);
                }
            }
            invokers = isGray ? this.route(routerProperties.getRouters(), invokers) : this.excludeGrayRoute(routerProperties.getRouters(), invokers);
        }
        return invokers;
    }

    private <T> List<Invoker<T>> route(List<String> routers, List<Invoker<T>> invokers) {
        ArrayList<Invoker<T>> invokerList = new ArrayList<Invoker<T>>();
        if (routers != null) {
            for (Invoker<T> invoker : invokers) {
                if (!routers.contains(invoker.getUrl().getIp())) continue;
                invokerList.add(invoker);
            }
        }
        return invokerList;
    }

    private <T> List<Invoker<T>> excludeGrayRoute(List<String> routers, List<Invoker<T>> invokers) {
        ArrayList<Invoker<T>> invokerList = new ArrayList<Invoker<T>>();
        for (Invoker<T> invoker : invokers) {
            if (routers != null && routers.contains(invoker.getUrl().getIp())) continue;
            invokerList.add(invoker);
        }
        return invokerList;
    }
}

