/*
 * Decompiled with CFR 0.152.
 */
package cn.w2n0.genghiskhan.dubbo.filter;

import cn.w2n0.genghiskhan.entity.BaseException;
import cn.w2n0.genghiskhan.entity.Result;
import java.lang.reflect.Method;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.filter.ExceptionFilter;
import org.apache.dubbo.rpc.service.GenericService;

@Activate(group={"provider"})
public class GlobalExceptionFilter
implements Filter,
Filter.Listener {
    private Logger logger = LoggerFactory.getLogger(ExceptionFilter.class);
    private final String JAVA = "java.";
    private final String JAVAX = "javax.";

    public org.apache.dubbo.rpc.Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        return invoker.invoke(invocation);
    }

    public void onResponse(org.apache.dubbo.rpc.Result appResponse, Invoker<?> invoker, Invocation invocation) {
        if (appResponse.hasException() && GenericService.class != invoker.getInterface()) {
            try {
                Throwable exception = appResponse.getException();
                if (exception instanceof BaseException) {
                    Result result = new Result();
                    result.setMsg(((BaseException)exception).getMsg());
                    result.setCode(((BaseException)exception).getCode());
                    result.setSuccess(false);
                    appResponse.setValue((Object)result);
                    appResponse.setException(null);
                    return;
                }
                if (!(exception instanceof RuntimeException) && exception instanceof Exception) {
                    return;
                }
                try {
                    Class<?>[] exceptionClassses;
                    Method method = invoker.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes());
                    for (Class<?> exceptionClass : exceptionClassses = method.getExceptionTypes()) {
                        if (!exception.getClass().equals(exceptionClass)) continue;
                        return;
                    }
                }
                catch (NoSuchMethodException e) {
                    return;
                }
                this.logger.error("Got unchecked and undeclared exception which called by " + RpcContext.getContext().getRemoteHost() + ". service: " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", exception: " + exception.getClass().getName() + ": " + exception.getMessage(), exception);
                String serviceFile = ReflectUtils.getCodeBase((Class)invoker.getInterface());
                String exceptionFile = ReflectUtils.getCodeBase(exception.getClass());
                if (serviceFile == null || exceptionFile == null || serviceFile.equals(exceptionFile)) {
                    return;
                }
                String className = exception.getClass().getName();
                if (className.startsWith("java.") || className.startsWith("javax.")) {
                    return;
                }
                if (exception instanceof RpcException) {
                    return;
                }
                appResponse.setException((Throwable)new RuntimeException(StringUtils.toString((Throwable)exception)));
            }
            catch (Throwable e) {
                this.logger.warn("Fail to ExceptionFilter when called by " + RpcContext.getContext().getRemoteHost() + ". service: " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", exception: " + e.getClass().getName() + ": " + e.getMessage(), e);
            }
        }
    }

    public void onError(Throwable e, Invoker<?> invoker, Invocation invocation) {
        this.logger.error("Got unchecked and undeclared exception which called by " + RpcContext.getContext().getRemoteHost() + ". service: " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", exception: " + e.getClass().getName() + ": " + e.getMessage(), e);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

