/*
 * Decompiled with CFR 0.152.
 */
package cn.w2n0.genghiskhan.dubbo.filter;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.MDC;

@Activate(group={"provider", "consumer"})
public class DubboTraceIdFilter
implements Filter {
    private final String TRACEID = "traceId";

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String traceId;
        RpcContext rpcContext = RpcContext.getContext();
        if (rpcContext.getUrl() == null) {
            traceId = invocation.getAttachment("traceId");
            MDC.put((String)"traceId", (String)traceId);
        } else {
            traceId = MDC.get((String)"traceId");
            rpcContext.setAttachment("traceId", traceId);
        }
        Result result = invoker.invoke(invocation);
        if (rpcContext.isProviderSide()) {
            MDC.remove((String)"traceId");
        }
        return result;
    }
}

