/*
 * Decompiled with CFR 0.152.
 */
package cn.w2n0.genghiskhan.dubbo;

import cn.w2n0.genghiskhan.dubbo.AbstractGeneric;
import cn.w2n0.genghiskhan.entity.Result;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.apache.dubbo.config.spring.extension.SpringExtensionFactory;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.service.GenericService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

public class DubboService
extends AbstractGeneric<ReferenceConfig>
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    private transient ApplicationContext applicationContext;
    private ConsumerConfig consumer;
    protected ApplicationConfig application;
    protected ModuleConfig module;
    protected List<RegistryConfig> registries;
    protected MonitorConfig monitor;

    @Override
    public Object invoke(String interfaceName, String version, String methodName, Map<String, Object> paramsMap) {
        ReferenceConfig reference = this.getReferenceConfig(interfaceName, version);
        if (null != reference) {
            GenericService genericService = (GenericService)reference.get();
            Object[] paramObject = null;
            if (!CollectionUtils.isEmpty(paramsMap)) {
                paramObject = new Object[]{paramsMap};
            }
            Object resultParam = null;
            resultParam = genericService.$invoke(methodName, null, paramObject);
            return resultParam;
        }
        return null;
    }

    @Override
    protected String invokeToJson(String interfaceName, String version, String methodName, Map<String, Object> paramsMap) {
        Result rpcResult;
        try {
            Object resultParam = this.invoke(methodName, version, methodName, paramsMap);
            if (resultParam instanceof Result) {
                rpcResult = (Result)resultParam;
            } else {
                rpcResult = new Result();
                rpcResult.setResult(resultParam);
            }
        }
        catch (RpcException ex) {
            rpcResult = new Result();
            switch (ex.getCode()) {
                case 1: {
                    rpcResult.setCode(10002);
                    break;
                }
                case 2: {
                    rpcResult.setCode(10003);
                    break;
                }
                case 5: {
                    rpcResult.setCode(10006);
                    break;
                }
                case 4: {
                    rpcResult.setCode(10005);
                    break;
                }
                case 3: {
                    rpcResult.setCode(10004);
                    break;
                }
                default: {
                    rpcResult.setCode(10001);
                }
            }
        }
        return JSONObject.toJSONString((Object)rpcResult);
    }

    private ReferenceConfig getReferenceConfig(String interfaceName, String version) {
        String referenceKey = interfaceName;
        ReferenceConfig referenceConfig = (ReferenceConfig)this.referenceCache.get(referenceKey);
        if (null == referenceConfig) {
            try {
                referenceConfig = new ReferenceConfig();
                referenceConfig.setRegistries(this.registries);
                referenceConfig.setConsumer(this.consumer);
                referenceConfig.setInterface(interfaceName);
                referenceConfig.setTimeout(Integer.valueOf(3000));
                referenceConfig.setRetries(Integer.valueOf(0));
                if (StringUtils.isNotEmpty((CharSequence)version)) {
                    referenceConfig.setVersion(version);
                }
                referenceConfig.setGeneric("true");
                this.referenceCache.put(referenceKey, referenceConfig);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return referenceConfig;
    }

    @Parameter(excluded=true)
    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        boolean correct;
        if (this.consumer == null) {
            Map consumerConfigMap;
            Map map = consumerConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ConsumerConfig.class, (boolean)false, (boolean)false);
            if (consumerConfigMap != null && consumerConfigMap.size() > 0) {
                ConsumerConfig consumerConfig = null;
                for (ConsumerConfig config : consumerConfigMap.values()) {
                    if (config.isDefault() != null && !config.isDefault().booleanValue()) continue;
                    if (consumerConfig != null) {
                        throw new IllegalStateException("Duplicate consumer configs: " + consumerConfig + " and " + config);
                    }
                    consumerConfig = config;
                }
                if (consumerConfig != null) {
                    this.consumer = consumerConfig;
                    this.consumer.setCheck(Boolean.valueOf(false));
                }
            }
        }
        boolean bl = correct = this.application == null && (this.consumer == null || this.consumer.getApplication() == null);
        if (correct) {
            Map applicationConfigMap;
            Map map = applicationConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ApplicationConfig.class, (boolean)false, (boolean)false);
            if (applicationConfigMap != null && applicationConfigMap.size() > 0) {
                ApplicationConfig applicationConfig = null;
                for (ApplicationConfig config : applicationConfigMap.values()) {
                    if (config.isDefault() != null && !config.isDefault().booleanValue()) continue;
                    if (applicationConfig != null) {
                        throw new IllegalStateException("Duplicate application configs: " + applicationConfig + " and " + config);
                    }
                    applicationConfig = config;
                }
                if (applicationConfig != null) {
                    this.application = applicationConfig;
                    DubboBootstrap.getInstance().application(applicationConfig);
                }
            }
        }
        boolean bl2 = correct = this.module == null && (this.consumer == null || this.consumer.getModule() == null);
        if (correct) {
            Map moduleConfigMap;
            Map map = moduleConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ModuleConfig.class, (boolean)false, (boolean)false);
            if (moduleConfigMap != null && moduleConfigMap.size() > 0) {
                ApplicationConfig moduleConfig = null;
                for (ApplicationConfig config : moduleConfigMap.values()) {
                    if (config.isDefault() != null && !config.isDefault().booleanValue()) continue;
                    if (moduleConfig != null) {
                        throw new IllegalStateException("Duplicate module configs: " + moduleConfig + " and " + config);
                    }
                    moduleConfig = config;
                }
                if (moduleConfig != null) {
                    this.module = moduleConfig;
                }
            }
        }
        boolean bl3 = correct = !(this.registries != null && this.registries.size() != 0 || this.consumer != null && this.consumer.getRegistries() != null && this.consumer.getRegistries().size() != 0 || this.application != null && this.application.getRegistries() != null && this.application.getRegistries().size() != 0);
        if (correct) {
            Map registryConfigMap;
            Map map = registryConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, RegistryConfig.class, (boolean)false, (boolean)false);
            if (registryConfigMap != null && registryConfigMap.size() > 0) {
                ArrayList<RegistryConfig> registryConfigs = new ArrayList<RegistryConfig>();
                for (ApplicationConfig config : registryConfigMap.values()) {
                    if (config.isDefault() != null && !config.isDefault().booleanValue()) continue;
                    registryConfigs.add((RegistryConfig)config);
                }
                if (registryConfigs != null && registryConfigs.size() > 0) {
                    this.registries = registryConfigs;
                }
            }
        }
        boolean bl4 = correct = !(this.monitor != null || this.consumer != null && this.consumer.getMonitor() != null || this.application != null && this.application.getMonitor() != null);
        if (correct) {
            Map monitorConfigMap;
            Map map = monitorConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, MonitorConfig.class, (boolean)false, (boolean)false);
            if (monitorConfigMap != null && monitorConfigMap.size() > 0) {
                ApplicationConfig monitorConfig = null;
                for (ApplicationConfig config : monitorConfigMap.values()) {
                    if (config.isDefault() != null && !config.isDefault().booleanValue()) continue;
                    if (monitorConfig != null) {
                        throw new IllegalStateException("Duplicate monitor configs: " + monitorConfig + " and " + config);
                    }
                    monitorConfig = config;
                }
                if (monitorConfig != null) {
                    this.monitor = monitorConfig;
                    DubboBootstrap.getInstance().monitor(monitorConfig);
                }
            }
        }
    }

    public void destroy() throws Exception {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        SpringExtensionFactory.addApplicationContext((ApplicationContext)applicationContext);
    }
}

