/*
 * Decompiled with CFR 0.152.
 */
package cn.w2n0.genghiskhan.dubbo.datasource.router;

import cn.w2n0.genghiskhan.datasource.DynamicDataSourceContextHolder;
import cn.w2n0.genghiskhan.dubbo.datasource.router.DataSourceRouterItemProperties;
import cn.w2n0.genghiskhan.dubbo.datasource.router.DataSourceRouterProperties;
import cn.w2n0.genghiskhan.dubbo.extend.TenantEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={DataSourceRouterProperties.class})
public class TenantDatabaseRouter {
    @Autowired
    private DataSourceRouterProperties dataSourceRouterProperties;
    @Value(value="${datasource-type}")
    private String type;

    @EventListener
    public void placeOrderNotice(TenantEntity tenantEntity) {
        if (StringUtils.isEmpty((CharSequence)this.type)) {
            throw new RuntimeException("The data source type is not configured for the current project!");
        }
        DynamicDataSourceContextHolder.remove();
        for (DataSourceRouterItemProperties item : this.dataSourceRouterProperties.getItems()) {
            if (!item.getTenant().equalsIgnoreCase(tenantEntity.getTenantId()) || !item.getType().equalsIgnoreCase(this.type)) continue;
            DynamicDataSourceContextHolder.setDataSource((String)item.getTag());
            return;
        }
    }
}

