/*
 * Decompiled with CFR 0.152.
 */
package cn.w2n0.genghiskhan.datasource;

import cn.w2n0.genghiskhan.datasource.DataSourceCreator;
import cn.w2n0.genghiskhan.datasource.DataSourceItemProperties;
import cn.w2n0.genghiskhan.datasource.DataSourceProperties;
import cn.w2n0.genghiskhan.datasource.DynamicDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.alibaba.druid.util.Utils;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={DataSourceProperties.class})
@ConditionalOnProperty(value={"genghiskhan.datasource.enable"})
public class DynamicDataSourceAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceAutoConfiguration.class);
    @Autowired
    private DataSourceProperties dataSourceProperties;
    @Autowired
    private DataSourceCreator dataSourceCreator;
    private final String DRUIDWEBURI = "/druid/js/common.js";

    @Bean(name={"dynamicDataSource"})
    @Primary
    public DynamicDataSource dynamicDataSource() {
        DynamicDataSource dataSource = new DynamicDataSource();
        HashMap<Object, Object> resolvedDataSources = new HashMap<Object, Object>(10);
        for (DataSourceItemProperties itemProperties : this.dataSourceProperties.getItems()) {
            resolvedDataSources.put(itemProperties.getTag(), this.dataSourceCreator.create(itemProperties));
        }
        dataSource.setTargetDataSources(resolvedDataSources);
        return dataSource;
    }

    @Bean(name={"wallFilter"})
    public WallFilter wallFilter() {
        WallFilter wallFilter = new WallFilter();
        wallFilter.setConfig(this.wallConfig());
        return wallFilter;
    }

    @Bean(name={"wallConfig"})
    public WallConfig wallConfig() {
        WallConfig config = new WallConfig();
        config.setMultiStatementAllow(true);
        config.setFunctionCheck(false);
        config.setStrictSyntaxCheck(false);
        config.setNoneBaseStatementAllow(true);
        return config;
    }

    @Bean
    public ServletRegistrationBean druidServlet() {
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[]{"/druid/*"});
        servletRegistrationBean.addInitParameter("allow", "127.0.0.1,10.1.1.1,210.12.66.240");
        servletRegistrationBean.addInitParameter("loginUsername", "admin");
        servletRegistrationBean.addInitParameter("loginPassword", "admin");
        servletRegistrationBean.addInitParameter("resetEnable", "false");
        return servletRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean filterRegistrationBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new WebStatFilter());
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        filterRegistrationBean.addInitParameter("exclusions", "*.js,*.gif,*.jpg,*.css,/druid/*");
        Filter filter = new Filter(){

            public void init(FilterConfig filterConfig) throws ServletException {
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                chain.doFilter(request, response);
                if (httpServletRequest.getRequestURI().contains("/druid/js/common.js")) {
                    String text = Utils.readFromResource((String)"support/http/resources/js/common.js");
                    text = text.replaceAll("<footer class=\"footer\">[^%]*</footer>", "");
                    response.getWriter().write(text);
                }
            }

            public void destroy() {
            }
        };
        filterRegistrationBean.setFilter(filter);
        return filterRegistrationBean;
    }
}

