/*
 * Decompiled with CFR 0.152.
 */
package cn.w2n0.genghiskhan.cache;

import cn.w2n0.genghiskhan.cache.ListCache;
import cn.w2n0.genghiskhan.cache.MapCache;
import cn.w2n0.genghiskhan.cache.SetCache;
import cn.w2n0.genghiskhan.cache.ZsetCache;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class RedisCache {
    private RedisTemplate redisTemplate;
    private SetCache setCache;
    private ZsetCache zSetCache;
    private MapCache mapCache;
    private ListCache listCache;
    public static final String LUA_SCRIPT = "return redis.call('cl.throttle',KEYS[1], ARGV[1], ARGV[2], ARGV[3], ARGV[4])";

    public RedisCache(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
        this.setCache = new SetCache(redisTemplate);
        this.zSetCache = new ZsetCache(redisTemplate);
        this.mapCache = new MapCache(redisTemplate);
        this.listCache = new ListCache(redisTemplate);
    }

    public <T> void setCacheObject(String key, T value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public <T> void setCacheObject(String key, T value, Integer timeout, TimeUnit timeUnit) {
        this.redisTemplate.opsForValue().set((Object)key, value, (long)timeout.intValue(), timeUnit);
    }

    public boolean expire(String key, long timeout) {
        return this.expire(key, timeout, TimeUnit.SECONDS);
    }

    public boolean expire(String key, long timeout, TimeUnit unit) {
        return this.redisTemplate.expire((Object)key, timeout, unit);
    }

    public <T> T getCacheObject(String key) {
        ValueOperations operation = this.redisTemplate.opsForValue();
        return (T)operation.get((Object)key);
    }

    public boolean deleteObject(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    public long deleteObject(Collection collection) {
        return this.redisTemplate.delete(collection);
    }

    public <T> long setCacheList(String key, List<T> dataList) {
        Long count = this.redisTemplate.opsForList().rightPushAll((Object)key, dataList);
        return count == null ? 0L : count;
    }

    public <T> List<T> getCacheList(String key) {
        return this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
    }

    public <T> long setCacheSet(String key, Set<T> dataSet) {
        if (dataSet != null) {
            SetOperations set = this.redisTemplate.opsForSet();
            dataSet.forEach(s -> set.add((Object)key, new Object[]{s}));
            return dataSet.size();
        }
        return 0L;
    }

    public <T> Set<T> getCacheSet(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public <T> void setCacheMap(String key, Map<String, T> dataMap) {
        if (dataMap != null) {
            this.redisTemplate.opsForHash().putAll((Object)key, dataMap);
        }
    }

    public <T> Map<String, T> getCacheMap(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public <T> List<T> getMultiCacheMapValue(String key, Collection<Object> hKeys) {
        return this.redisTemplate.opsForHash().multiGet((Object)key, hKeys);
    }

    public long deleteKey(String key, String hashKey) {
        return this.redisTemplate.opsForHash().delete((Object)key, new Object[]{hashKey});
    }

    public Collection<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public <T> List<T> getCacheListObject(String pattern) {
        Collection<String> keys = this.keys(pattern);
        return this.getCacheListObject(keys);
    }

    public <T> List<T> getCacheListObject(Collection<String> keys) {
        ValueOperations operation = this.redisTemplate.opsForValue();
        return operation.multiGet(keys);
    }

    public boolean redisCellDemo(String key, int maxBurst, int countPerPeriod, int period, int quantity) {
        try {
            DefaultRedisScript script = new DefaultRedisScript(LUA_SCRIPT, List.class);
            List rst = (List)this.redisTemplate.execute((RedisScript)script, Arrays.asList(key), new Object[]{maxBurst, countPerPeriod, period, quantity});
            return (Long)rst.get(0) == 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public SetCache getSetCache() {
        return this.setCache;
    }

    public ZsetCache getZSetCache() {
        return this.zSetCache;
    }

    public MapCache getMapCache() {
        return this.mapCache;
    }

    public ListCache getListCache() {
        return this.listCache;
    }
}

