/*
 * Decompiled with CFR 0.152.
 */
package cn.w2n0.genghiskhan.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class MapCache {
    public RedisTemplate redisTemplate;

    public MapCache(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public <T> void hset(String key, String field, T value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)field, value);
    }

    public <T> T hget(String key, String field) {
        HashOperations opsForHash = this.redisTemplate.opsForHash();
        return (T)opsForHash.get((Object)key, (Object)field);
    }

    public void hdel(String key, String field) {
        this.redisTemplate.opsForHash().delete((Object)key, new Object[]{field});
    }

    public long hincr(String key, String field, long value) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)field, value);
    }

    public <T> Map<String, T> hmget(String key, List<String> fields) {
        List result = this.redisTemplate.opsForHash().multiGet((Object)key, fields);
        HashMap ans = new HashMap(fields.size());
        int index = 0;
        for (String field : fields) {
            if (result.get(index) == null) continue;
            ans.put(field, result.get(index));
        }
        return ans;
    }
}

