/*
 * Decompiled with CFR 0.152.
 */
package cn.w2n0.genghiskhan.alarm;

import cn.w2n0.genghiskhan.alarm.dingtalk.DingdingUtils;
import cn.w2n0.genghiskhan.alarm.dingtalk.entity.MsgEntity;
import cn.w2n0.genghiskhan.alarm.mail.MailSending;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class AlarmSendingTemplate {
    @Autowired
    private MailSending mailSending;
    private ExecutorService executorService;

    public AlarmSendingTemplate() {
        CustomizableThreadFactory springThreadFactory = new CustomizableThreadFactory("springThread-pool-Alarm-");
        this.executorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)springThreadFactory);
    }

    public void syncsendMail(String[] tos, String subject, String text) {
        this.mailSending.send(tos, subject, text);
    }

    public void asyncSendMail(final String[] tos, final String subject, final String text) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                AlarmSendingTemplate.this.mailSending.send(tos, subject, text);
            }
        });
    }

    public void sendDingTalk(MsgEntity msgEntity, String webHook) {
        DingdingUtils.sendToDingding(msgEntity.getJSONObjectString(), webHook);
    }

    public void asyncSendDingTalk(final MsgEntity msgEntity, final String webHook) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                DingdingUtils.sendToDingding(msgEntity.getJSONObjectString(), webHook);
            }
        });
    }
}

