/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.validator.rule.impl;

import cn.vonce.validator.annotation.VPhone;
import cn.vonce.validator.helper.WhatType;
import cn.vonce.validator.model.FieldInfo;
import cn.vonce.validator.rule.AbstractValidate;
import cn.vonce.validator.utils.ValidatorRuleUtil;

public class ValidatePhone
extends AbstractValidate<VPhone> {
    @Override
    public WhatType[] type() {
        return new WhatType[]{WhatType.STRING_TYPE};
    }

    @Override
    public String getAnticipate(VPhone valid) {
        if (valid.phoneType() == VPhone.VPhoneType.TELEPHONE) {
            return "'\u6807\u51c6\u7535\u8bdd\u53f7\u7801\u683c\u5f0f'";
        }
        return "'\u6807\u51c6\u624b\u673a\u53f7\u7801\u683c\u5f0f'";
    }

    @Override
    public boolean check(VPhone valid, FieldInfo fieldInfo) {
        switch (valid.phoneType()) {
            case MOBILEPHONE: {
                if (ValidatorRuleUtil.isMobilePhone(fieldInfo.getValue().toString())) break;
                return false;
            }
            case TELEPHONE: {
                if (ValidatorRuleUtil.isTelePhone(fieldInfo.getValue().toString())) break;
                return false;
            }
        }
        return true;
    }
}

