/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.validator.rule.impl;

import cn.vonce.validator.annotation.VNumber;
import cn.vonce.validator.helper.WhatType;
import cn.vonce.validator.model.FieldInfo;
import cn.vonce.validator.rule.AbstractValidate;
import org.apache.commons.lang.math.NumberUtils;

public class ValidateNumber
extends AbstractValidate<VNumber> {
    @Override
    public WhatType[] type() {
        return new WhatType[]{WhatType.STRING_TYPE};
    }

    @Override
    public String getAnticipate(VNumber valid) {
        String anticipate = "";
        if (valid.val() == VNumber.NumType.NUMBER) {
            anticipate = "'\u6570\u5b57\u7c7b\u578b'";
        } else if (valid.val() == VNumber.NumType.INTEGER) {
            anticipate = "'\u6574\u6570\u7c7b\u578b'";
        } else if (valid.val() == VNumber.NumType.FLOAT) {
            anticipate = "'\u6d6e\u70b9\u7c7b\u578b'";
        }
        return anticipate;
    }

    @Override
    public boolean check(VNumber valid, FieldInfo fieldInfo) {
        int index = fieldInfo.getValue().toString().indexOf(".");
        switch (valid.val()) {
            case NUMBER: {
                if (NumberUtils.isNumber((String)fieldInfo.getValue().toString())) break;
                return false;
            }
            case INTEGER: {
                if (NumberUtils.isNumber((String)fieldInfo.getValue().toString()) && (index <= -1 || index >= fieldInfo.getValue().toString().length() - 1)) break;
                return false;
            }
            case FLOAT: {
                if (NumberUtils.isNumber((String)fieldInfo.getValue().toString()) && index != -1 && index != fieldInfo.getValue().toString().length() - 1) break;
                return false;
            }
        }
        return true;
    }
}

